/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme;

import android.graphics.Color;
import java.util.ArrayList;
import java.util.List;
import org.mapsforge.v3.android.maps.rendertheme.Closed;
import org.mapsforge.v3.android.maps.rendertheme.MatchingCacheKey;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.Rule;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.LRUCache;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public class RenderTheme {
    private static final int MATCHING_CACHE_SIZE = 512;
    private static final int RENDER_THEME_VERSION = 1;
    private final float baseStrokeWidth;
    private final float baseTextSize;
    private int levels;
    private final int mapBackground;
    private final LRUCache<MatchingCacheKey, List<RenderInstruction>> matchingCache;
    private final ArrayList<Rule> rulesList;

    private static void validate(String elementName, Integer version, float baseStrokeWidth, float baseTextSize) {
        if (version == null) {
            throw new IllegalArgumentException("missing attribute version for element:" + elementName);
        }
        if (version != 1) {
            throw new IllegalArgumentException("invalid render theme version:" + version);
        }
        if (baseStrokeWidth < 0.0f) {
            throw new IllegalArgumentException("base-stroke-width must not be negative: " + baseStrokeWidth);
        }
        if (baseTextSize < 0.0f) {
            throw new IllegalArgumentException("base-text-size must not be negative: " + baseTextSize);
        }
    }

    static RenderTheme create(String elementName, Attributes attributes) {
        Integer version = null;
        int mapBackground = -1;
        float baseStrokeWidth = 1.0f;
        float baseTextSize = 1.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("schemaLocation".equals(name)) continue;
            if ("version".equals(name)) {
                version = Integer.parseInt(value);
                continue;
            }
            if ("map-background".equals(name)) {
                mapBackground = Color.parseColor((String)value);
                continue;
            }
            if ("base-stroke-width".equals(name)) {
                baseStrokeWidth = Float.parseFloat(value);
                continue;
            }
            if ("base-text-size".equals(name)) {
                baseTextSize = Float.parseFloat(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        RenderTheme.validate(elementName, version, baseStrokeWidth, baseTextSize);
        return new RenderTheme(mapBackground, baseStrokeWidth, baseTextSize);
    }

    RenderTheme(int mapBackground, float baseStrokeWidth, float baseTextSize) {
        this.mapBackground = mapBackground;
        this.baseStrokeWidth = baseStrokeWidth;
        this.baseTextSize = baseTextSize;
        this.rulesList = new ArrayList();
        this.matchingCache = new LRUCache(512);
    }

    public void destroy() {
        this.matchingCache.clear();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).onDestroy();
        }
    }

    public int getLevels() {
        return this.levels;
    }

    public int getMapBackground() {
        return this.mapBackground;
    }

    public void matchClosedWay(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel) {
        this.matchWay(renderCallback, tags, zoomLevel, Closed.YES);
    }

    public void matchLinearWay(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel) {
        this.matchWay(renderCallback, tags, zoomLevel, Closed.NO);
    }

    public void matchNode(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel) {
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchNode(renderCallback, tags, zoomLevel);
        }
    }

    public void scaleStrokeWidth(float scaleFactor) {
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).scaleStrokeWidth(scaleFactor * this.baseStrokeWidth);
        }
    }

    public void scaleTextSize(float scaleFactor) {
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).scaleTextSize(scaleFactor * this.baseTextSize);
        }
    }

    private void matchWay(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel, Closed closed) {
        MatchingCacheKey matchingCacheKey = new MatchingCacheKey(tags, zoomLevel, closed);
        ArrayList<RenderInstruction> matchingList = (ArrayList<RenderInstruction>)this.matchingCache.get(matchingCacheKey);
        if (matchingList != null) {
            int n = matchingList.size();
            for (int i = 0; i < n; ++i) {
                ((RenderInstruction)matchingList.get(i)).renderWay(renderCallback, tags);
            }
            return;
        }
        matchingList = new ArrayList<RenderInstruction>();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).matchWay(renderCallback, tags, zoomLevel, closed, matchingList);
        }
        this.matchingCache.put(matchingCacheKey, matchingList);
    }

    void addRule(Rule rule) {
        this.rulesList.add(rule);
    }

    void complete() {
        this.rulesList.trimToSize();
        int n = this.rulesList.size();
        for (int i = 0; i < n; ++i) {
            this.rulesList.get(i).onComplete();
        }
    }

    void setLevels(int levels) {
        this.levels = levels;
    }
}

