/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.mapsforge.v3.android.maps.mapgenerator.JobTheme;
import org.mapsforge.v3.android.maps.rendertheme.RenderTheme;
import org.mapsforge.v3.android.maps.rendertheme.Rule;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.Area;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.Caption;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.Circle;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.Line;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.LineSymbol;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.PathText;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.Symbol;
import org.mapsforge.v3.core.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class RenderThemeHandler
extends DefaultHandler {
    private static final String ELEMENT_NAME_RENDER_THEME = "rendertheme";
    private static final String ELEMENT_NAME_RULE = "rule";
    private static final Logger LOG = Logger.getLogger(RenderThemeHandler.class.getName());
    private static final String UNEXPECTED_ELEMENT = "unexpected element: ";
    private Rule currentRule;
    private final Stack<Element> elementStack = new Stack();
    private int level;
    private final String relativePathPrefix;
    private RenderTheme renderTheme;
    private final Stack<Rule> ruleStack = new Stack();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderTheme getRenderTheme(JobTheme jobTheme) throws SAXException, ParserConfigurationException, IOException {
        RenderThemeHandler renderThemeHandler = new RenderThemeHandler(jobTheme.getRelativePathPrefix());
        XMLReader xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xmlReader.setContentHandler(renderThemeHandler);
        InputStream inputStream = null;
        try {
            inputStream = jobTheme.getRenderThemeAsStream();
            xmlReader.parse(new InputSource(inputStream));
            RenderTheme renderTheme = renderThemeHandler.renderTheme;
            return renderTheme;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public static void logUnknownAttribute(String element, String name, String value, int attributeIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unknown attribute in element ");
        stringBuilder.append(element);
        stringBuilder.append(" (");
        stringBuilder.append(attributeIndex);
        stringBuilder.append("): ");
        stringBuilder.append(name);
        stringBuilder.append('=');
        stringBuilder.append(value);
        LOG.info(stringBuilder.toString());
    }

    private RenderThemeHandler(String relativePathPrefix) {
        this.relativePathPrefix = relativePathPrefix;
    }

    @Override
    public void endDocument() {
        if (this.renderTheme == null) {
            throw new IllegalArgumentException("missing element: rules");
        }
        this.renderTheme.setLevels(this.level);
        this.renderTheme.complete();
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.elementStack.pop();
        if (ELEMENT_NAME_RULE.equals(localName)) {
            this.ruleStack.pop();
            if (this.ruleStack.empty()) {
                this.renderTheme.addRule(this.currentRule);
            } else {
                this.currentRule = this.ruleStack.peek();
            }
        }
    }

    @Override
    public void error(SAXParseException exception) {
        LOG.log(Level.SEVERE, null, exception);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        block13: {
            try {
                if (ELEMENT_NAME_RENDER_THEME.equals(localName)) {
                    this.checkState(localName, Element.RENDER_THEME);
                    this.renderTheme = RenderTheme.create(localName, attributes);
                    break block13;
                }
                if (ELEMENT_NAME_RULE.equals(localName)) {
                    this.checkState(localName, Element.RULE);
                    Rule rule = Rule.create(localName, attributes, this.ruleStack);
                    if (!this.ruleStack.empty()) {
                        this.currentRule.addSubRule(rule);
                    }
                    this.currentRule = rule;
                    this.ruleStack.push(this.currentRule);
                    break block13;
                }
                if ("area".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    Area area = Area.create(localName, attributes, this.level++, this.relativePathPrefix);
                    this.ruleStack.peek().addRenderingInstruction(area);
                    break block13;
                }
                if ("caption".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    Caption caption = Caption.create(localName, attributes);
                    this.currentRule.addRenderingInstruction(caption);
                    break block13;
                }
                if ("circle".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    Circle circle = Circle.create(localName, attributes, this.level++);
                    this.currentRule.addRenderingInstruction(circle);
                    break block13;
                }
                if ("line".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    Line line = Line.create(localName, attributes, this.level++, this.relativePathPrefix);
                    this.currentRule.addRenderingInstruction(line);
                    break block13;
                }
                if ("lineSymbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    LineSymbol lineSymbol = LineSymbol.create(localName, attributes, this.relativePathPrefix);
                    this.currentRule.addRenderingInstruction(lineSymbol);
                    break block13;
                }
                if ("pathText".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    PathText pathText = PathText.create(localName, attributes);
                    this.currentRule.addRenderingInstruction(pathText);
                    break block13;
                }
                if ("symbol".equals(localName)) {
                    this.checkState(localName, Element.RENDERING_INSTRUCTION);
                    Symbol symbol = Symbol.create(localName, attributes, this.relativePathPrefix);
                    this.currentRule.addRenderingInstruction(symbol);
                    break block13;
                }
                throw new SAXException("unknown element: " + localName);
            }
            catch (IllegalArgumentException e) {
                throw new SAXException(null, e);
            }
            catch (IOException e) {
                throw new SAXException(null, e);
            }
        }
    }

    @Override
    public void warning(SAXParseException exception) {
        LOG.log(Level.SEVERE, null, exception);
    }

    private void checkElement(String elementName, Element element) throws SAXException {
        switch (element) {
            case RENDER_THEME: {
                if (!this.elementStack.empty()) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RULE: {
                Element parentElement = this.elementStack.peek();
                if (parentElement != Element.RENDER_THEME && parentElement != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
            case RENDERING_INSTRUCTION: {
                if (this.elementStack.peek() != Element.RULE) {
                    throw new SAXException(UNEXPECTED_ELEMENT + elementName);
                }
                return;
            }
        }
        throw new SAXException("unknown enum value: " + (Object)((Object)element));
    }

    private void checkState(String elementName, Element element) throws SAXException {
        this.checkElement(elementName, element);
        this.elementStack.push(element);
    }

    private static enum Element {
        RENDER_THEME,
        RENDERING_INSTRUCTION,
        RULE;

    }
}

