/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Pattern;
import org.mapsforge.v3.android.maps.rendertheme.AnyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.AttributeMatcher;
import org.mapsforge.v3.android.maps.rendertheme.Closed;
import org.mapsforge.v3.android.maps.rendertheme.ClosedMatcher;
import org.mapsforge.v3.android.maps.rendertheme.ClosedWayMatcher;
import org.mapsforge.v3.android.maps.rendertheme.Element;
import org.mapsforge.v3.android.maps.rendertheme.ElementMatcher;
import org.mapsforge.v3.android.maps.rendertheme.ElementNodeMatcher;
import org.mapsforge.v3.android.maps.rendertheme.ElementWayMatcher;
import org.mapsforge.v3.android.maps.rendertheme.LinearWayMatcher;
import org.mapsforge.v3.android.maps.rendertheme.MultiKeyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.MultiValueMatcher;
import org.mapsforge.v3.android.maps.rendertheme.NegativeMatcher;
import org.mapsforge.v3.android.maps.rendertheme.NegativeRule;
import org.mapsforge.v3.android.maps.rendertheme.PositiveRule;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.RuleOptimizer;
import org.mapsforge.v3.android.maps.rendertheme.SingleKeyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.SingleValueMatcher;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

abstract class Rule {
    private static final Map<List<String>, AttributeMatcher> MATCHERS_CACHE_KEY = new HashMap<List<String>, AttributeMatcher>();
    private static final Map<List<String>, AttributeMatcher> MATCHERS_CACHE_VALUE = new HashMap<List<String>, AttributeMatcher>();
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\|");
    private static final String STRING_NEGATION = "~";
    private static final String STRING_WILDCARD = "*";
    private static final String UNKNOWN_ENUM_VALUE = "unknown enum value: ";
    private final ArrayList<RenderInstruction> renderInstructions;
    private final ArrayList<Rule> subRules;
    final ClosedMatcher closedMatcher;
    final ElementMatcher elementMatcher;
    final byte zoomMax;
    final byte zoomMin;

    private static Rule createRule(Stack<Rule> ruleStack, Element element, String keys, String values, Closed closed, byte zoomMin, byte zoomMax) {
        ElementMatcher elementMatcher = Rule.getElementMatcher(element);
        ClosedMatcher closedMatcher = Rule.getClosedMatcher(closed);
        ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(SPLIT_PATTERN.split(keys)));
        ArrayList<String> valueList = new ArrayList<String>(Arrays.asList(SPLIT_PATTERN.split(values)));
        elementMatcher = RuleOptimizer.optimize(elementMatcher, ruleStack);
        closedMatcher = RuleOptimizer.optimize(closedMatcher, ruleStack);
        if (valueList.remove(STRING_NEGATION)) {
            NegativeMatcher attributeMatcher = new NegativeMatcher(keyList, valueList);
            return new NegativeRule(elementMatcher, closedMatcher, zoomMin, zoomMax, attributeMatcher);
        }
        AttributeMatcher keyMatcher = Rule.getKeyMatcher(keyList);
        AttributeMatcher valueMatcher = Rule.getValueMatcher(valueList);
        keyMatcher = RuleOptimizer.optimize(keyMatcher, ruleStack);
        valueMatcher = RuleOptimizer.optimize(valueMatcher, ruleStack);
        return new PositiveRule(elementMatcher, closedMatcher, zoomMin, zoomMax, keyMatcher, valueMatcher);
    }

    private static ClosedMatcher getClosedMatcher(Closed closed) {
        switch (closed) {
            case YES: {
                return ClosedWayMatcher.getInstance();
            }
            case NO: {
                return LinearWayMatcher.getInstance();
            }
            case ANY: {
                return AnyMatcher.getInstance();
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ENUM_VALUE + (Object)((Object)closed));
    }

    private static ElementMatcher getElementMatcher(Element element) {
        switch (element) {
            case NODE: {
                return ElementNodeMatcher.getInstance();
            }
            case WAY: {
                return ElementWayMatcher.getInstance();
            }
            case ANY: {
                return AnyMatcher.getInstance();
            }
        }
        throw new IllegalArgumentException(UNKNOWN_ENUM_VALUE + (Object)((Object)element));
    }

    private static AttributeMatcher getKeyMatcher(List<String> keyList) {
        if (STRING_WILDCARD.equals(keyList.get(0))) {
            return AnyMatcher.getInstance();
        }
        AttributeMatcher attributeMatcher = MATCHERS_CACHE_KEY.get(keyList);
        if (attributeMatcher == null) {
            attributeMatcher = keyList.size() == 1 ? new SingleKeyMatcher(keyList.get(0)) : new MultiKeyMatcher(keyList);
            MATCHERS_CACHE_KEY.put(keyList, attributeMatcher);
        }
        return attributeMatcher;
    }

    private static AttributeMatcher getValueMatcher(List<String> valueList) {
        if (STRING_WILDCARD.equals(valueList.get(0))) {
            return AnyMatcher.getInstance();
        }
        AttributeMatcher attributeMatcher = MATCHERS_CACHE_VALUE.get(valueList);
        if (attributeMatcher == null) {
            attributeMatcher = valueList.size() == 1 ? new SingleValueMatcher(valueList.get(0)) : new MultiValueMatcher(valueList);
            MATCHERS_CACHE_VALUE.put(valueList, attributeMatcher);
        }
        return attributeMatcher;
    }

    private static void validate(String elementName, Element element, String keys, String values, byte zoomMin, byte zoomMax) {
        if (element == null) {
            throw new IllegalArgumentException("missing attribute e for element: " + elementName);
        }
        if (keys == null) {
            throw new IllegalArgumentException("missing attribute k for element: " + elementName);
        }
        if (values == null) {
            throw new IllegalArgumentException("missing attribute v for element: " + elementName);
        }
        if (zoomMin < 0) {
            throw new IllegalArgumentException("zoom-min must not be negative: " + zoomMin);
        }
        if (zoomMax < 0) {
            throw new IllegalArgumentException("zoom-max must not be negative: " + zoomMax);
        }
        if (zoomMin > zoomMax) {
            throw new IllegalArgumentException("zoom-min must be less or equal zoom-max: " + zoomMin);
        }
    }

    static Rule create(String elementName, Attributes attributes, Stack<Rule> ruleStack) {
        Element element = null;
        String keys = null;
        String values = null;
        Closed closed = Closed.ANY;
        byte zoomMin = 0;
        byte zoomMax = 127;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("e".equals(name)) {
                element = Element.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("k".equals(name)) {
                keys = value;
                continue;
            }
            if ("v".equals(name)) {
                values = value;
                continue;
            }
            if ("closed".equals(name)) {
                closed = Closed.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("zoom-min".equals(name)) {
                zoomMin = Byte.parseByte(value);
                continue;
            }
            if ("zoom-max".equals(name)) {
                zoomMax = Byte.parseByte(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Rule.validate(elementName, element, keys, values, zoomMin, zoomMax);
        return Rule.createRule(ruleStack, element, keys, values, closed, zoomMin, zoomMax);
    }

    Rule(ElementMatcher elementMatcher, ClosedMatcher closedMatcher, byte zoomMin, byte zoomMax) {
        this.elementMatcher = elementMatcher;
        this.closedMatcher = closedMatcher;
        this.zoomMin = zoomMin;
        this.zoomMax = zoomMax;
        this.renderInstructions = new ArrayList(4);
        this.subRules = new ArrayList(4);
    }

    void addRenderingInstruction(RenderInstruction renderInstruction) {
        this.renderInstructions.add(renderInstruction);
    }

    void addSubRule(Rule rule) {
        this.subRules.add(rule);
    }

    abstract boolean matchesNode(List<Tag> var1, byte var2);

    abstract boolean matchesWay(List<Tag> var1, byte var2, Closed var3);

    void matchNode(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel) {
        if (this.matchesNode(tags, zoomLevel)) {
            int i;
            int n = this.renderInstructions.size();
            for (i = 0; i < n; ++i) {
                this.renderInstructions.get(i).renderNode(renderCallback, tags);
            }
            n = this.subRules.size();
            for (i = 0; i < n; ++i) {
                this.subRules.get(i).matchNode(renderCallback, tags, zoomLevel);
            }
        }
    }

    void matchWay(RenderCallback renderCallback, List<Tag> tags, byte zoomLevel, Closed closed, List<RenderInstruction> matchingList) {
        if (this.matchesWay(tags, zoomLevel, closed)) {
            int i;
            int n = this.renderInstructions.size();
            for (i = 0; i < n; ++i) {
                this.renderInstructions.get(i).renderWay(renderCallback, tags);
                matchingList.add(this.renderInstructions.get(i));
            }
            n = this.subRules.size();
            for (i = 0; i < n; ++i) {
                this.subRules.get(i).matchWay(renderCallback, tags, zoomLevel, closed, matchingList);
            }
        }
    }

    void onComplete() {
        MATCHERS_CACHE_KEY.clear();
        MATCHERS_CACHE_VALUE.clear();
        this.renderInstructions.trimToSize();
        this.subRules.trimToSize();
        int n = this.subRules.size();
        for (int i = 0; i < n; ++i) {
            this.subRules.get(i).onComplete();
        }
    }

    void onDestroy() {
        int i;
        int n = this.renderInstructions.size();
        for (i = 0; i < n; ++i) {
            this.renderInstructions.get(i).destroy();
        }
        n = this.subRules.size();
        for (i = 0; i < n; ++i) {
            this.subRules.get(i).onDestroy();
        }
    }

    void scaleStrokeWidth(float scaleFactor) {
        int i;
        int n = this.renderInstructions.size();
        for (i = 0; i < n; ++i) {
            this.renderInstructions.get(i).scaleStrokeWidth(scaleFactor);
        }
        n = this.subRules.size();
        for (i = 0; i < n; ++i) {
            this.subRules.get(i).scaleStrokeWidth(scaleFactor);
        }
    }

    void scaleTextSize(float scaleFactor) {
        int i;
        int n = this.renderInstructions.size();
        for (i = 0; i < n; ++i) {
            this.renderInstructions.get(i).scaleTextSize(scaleFactor);
        }
        n = this.subRules.size();
        for (i = 0; i < n; ++i) {
            this.subRules.get(i).scaleTextSize(scaleFactor);
        }
    }
}

