/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme;

import java.util.Stack;
import java.util.logging.Logger;
import org.mapsforge.v3.android.maps.rendertheme.AnyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.AttributeMatcher;
import org.mapsforge.v3.android.maps.rendertheme.ClosedMatcher;
import org.mapsforge.v3.android.maps.rendertheme.ElementMatcher;
import org.mapsforge.v3.android.maps.rendertheme.MultiKeyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.MultiValueMatcher;
import org.mapsforge.v3.android.maps.rendertheme.NegativeMatcher;
import org.mapsforge.v3.android.maps.rendertheme.PositiveRule;
import org.mapsforge.v3.android.maps.rendertheme.Rule;
import org.mapsforge.v3.android.maps.rendertheme.SingleKeyMatcher;
import org.mapsforge.v3.android.maps.rendertheme.SingleValueMatcher;

final class RuleOptimizer {
    private static final Logger LOG = Logger.getLogger(RuleOptimizer.class.getName());

    private static AttributeMatcher optimizeKeyMatcher(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (!(ruleStack.get(i) instanceof PositiveRule)) continue;
            PositiveRule positiveRule = (PositiveRule)ruleStack.get(i);
            if (!positiveRule.keyMatcher.isCoveredBy(attributeMatcher)) continue;
            return AnyMatcher.getInstance();
        }
        return attributeMatcher;
    }

    private static AttributeMatcher optimizeValueMatcher(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (!(ruleStack.get(i) instanceof PositiveRule)) continue;
            PositiveRule positiveRule = (PositiveRule)ruleStack.get(i);
            if (!positiveRule.valueMatcher.isCoveredBy(attributeMatcher)) continue;
            return AnyMatcher.getInstance();
        }
        return attributeMatcher;
    }

    static AttributeMatcher optimize(AttributeMatcher attributeMatcher, Stack<Rule> ruleStack) {
        if (attributeMatcher instanceof AnyMatcher || attributeMatcher instanceof NegativeMatcher) {
            return attributeMatcher;
        }
        if (attributeMatcher instanceof SingleKeyMatcher) {
            return RuleOptimizer.optimizeKeyMatcher(attributeMatcher, ruleStack);
        }
        if (attributeMatcher instanceof SingleValueMatcher) {
            return RuleOptimizer.optimizeValueMatcher(attributeMatcher, ruleStack);
        }
        if (attributeMatcher instanceof MultiKeyMatcher) {
            return RuleOptimizer.optimizeKeyMatcher(attributeMatcher, ruleStack);
        }
        if (attributeMatcher instanceof MultiValueMatcher) {
            return RuleOptimizer.optimizeValueMatcher(attributeMatcher, ruleStack);
        }
        throw new IllegalArgumentException("unknown AttributeMatcher: " + attributeMatcher);
    }

    static ClosedMatcher optimize(ClosedMatcher closedMatcher, Stack<Rule> ruleStack) {
        if (closedMatcher instanceof AnyMatcher) {
            return closedMatcher;
        }
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (((Rule)ruleStack.get((int)i)).closedMatcher.isCoveredBy(closedMatcher)) {
                return AnyMatcher.getInstance();
            }
            if (closedMatcher.isCoveredBy(((Rule)ruleStack.get((int)i)).closedMatcher)) continue;
            LOG.warning("unreachable rule (closed)");
        }
        return closedMatcher;
    }

    static ElementMatcher optimize(ElementMatcher elementMatcher, Stack<Rule> ruleStack) {
        if (elementMatcher instanceof AnyMatcher) {
            return elementMatcher;
        }
        int n = ruleStack.size();
        for (int i = 0; i < n; ++i) {
            if (((Rule)ruleStack.get((int)i)).elementMatcher.isCoveredBy(elementMatcher)) {
                return AnyMatcher.getInstance();
            }
            if (elementMatcher.isCoveredBy(((Rule)ruleStack.get((int)i)).elementMatcher)) continue;
            LOG.warning("unreachable rule (e)");
        }
        return elementMatcher;
    }

    private RuleOptimizer() {
    }
}

