/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.BitmapShader;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Shader;
import java.io.IOException;
import java.util.List;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.BitmapUtils;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class Area
implements RenderInstruction {
    private final Paint fill;
    private final int level;
    private final Paint outline;
    private final float strokeWidth;

    public static Area create(String elementName, Attributes attributes, int level, String relativePathPrefix) throws IOException {
        String src = null;
        int fill = -16777216;
        int stroke = 0;
        float strokeWidth = 0.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("fill".equals(name)) {
                fill = Color.parseColor((String)value);
                continue;
            }
            if ("stroke".equals(name)) {
                stroke = Color.parseColor((String)value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                strokeWidth = Float.parseFloat(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Area.validate(strokeWidth);
        return new Area(relativePathPrefix, src, fill, stroke, strokeWidth, level);
    }

    private static void validate(float strokeWidth) {
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("stroke-width must not be negative: " + strokeWidth);
        }
    }

    private Area(String relativePathPrefix, String src, int fill, int stroke, float strokeWidth, int level) throws IOException {
        BitmapShader shader = BitmapUtils.createBitmapShader(relativePathPrefix, src);
        if (fill == 0) {
            this.fill = null;
        } else {
            this.fill = new Paint(1);
            this.fill.setShader((Shader)shader);
            this.fill.setStyle(Paint.Style.FILL);
            this.fill.setColor(fill);
            this.fill.setStrokeCap(Paint.Cap.ROUND);
        }
        if (stroke == 0) {
            this.outline = null;
        } else {
            this.outline = new Paint(1);
            this.outline.setStyle(Paint.Style.STROKE);
            this.outline.setColor(stroke);
            this.outline.setStrokeCap(Paint.Cap.ROUND);
        }
        this.strokeWidth = strokeWidth;
        this.level = level;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
        if (this.outline != null) {
            renderCallback.renderArea(this.outline, this.level);
        }
        if (this.fill != null) {
            renderCallback.renderArea(this.fill, this.level);
        }
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
        if (this.outline != null) {
            this.outline.setStrokeWidth(this.strokeWidth * scaleFactor);
        }
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
    }
}

