/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

final class BitmapUtils {
    private static final String PREFIX_FILE = "file:";
    private static final String PREFIX_JAR = "jar:";

    private static InputStream createInputStream(String relativePathPrefix, String src) throws FileNotFoundException {
        if (src.startsWith(PREFIX_JAR)) {
            String absoluteName = BitmapUtils.getAbsoluteName(relativePathPrefix, src.substring(PREFIX_JAR.length()));
            InputStream inputStream = BitmapUtils.class.getResourceAsStream(absoluteName);
            if (inputStream == null) {
                throw new FileNotFoundException("resource not found: " + absoluteName);
            }
            return inputStream;
        }
        if (src.startsWith(PREFIX_FILE)) {
            File file = BitmapUtils.getFile(relativePathPrefix, src.substring(PREFIX_FILE.length()));
            if (!file.exists()) {
                throw new IllegalArgumentException("file does not exist: " + file);
            }
            if (!file.isFile()) {
                throw new IllegalArgumentException("not a file: " + file);
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException("cannot read file: " + file);
            }
            return new FileInputStream(file);
        }
        throw new IllegalArgumentException("invalid bitmap source: " + src);
    }

    private static String getAbsoluteName(String relativePathPrefix, String name) {
        if (name.charAt(0) == '/') {
            return name;
        }
        return relativePathPrefix + name;
    }

    private static File getFile(String parentPath, String pathName) {
        return new File(parentPath, pathName);
    }

    static Bitmap createBitmap(String relativePathPrefix, String src) throws IOException {
        if (src == null || src.length() == 0) {
            return null;
        }
        InputStream inputStream = BitmapUtils.createInputStream(relativePathPrefix, src);
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        inputStream.close();
        return bitmap;
    }

    static BitmapShader createBitmapShader(String relativePathPrefix, String src) throws IOException {
        Bitmap bitmap = BitmapUtils.createBitmap(relativePathPrefix, src);
        if (bitmap == null) {
            return null;
        }
        return new BitmapShader(bitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
    }

    private BitmapUtils() {
        throw new IllegalStateException();
    }
}

