/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import java.util.List;
import java.util.Locale;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.FontFamily;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.FontStyle;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.TextKey;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class Caption
implements RenderInstruction {
    private final float dy;
    private final float fontSize;
    private final Paint paint;
    private final Paint stroke;
    private final TextKey textKey;

    public static Caption create(String elementName, Attributes attributes) {
        TextKey textKey = null;
        float dy = 0.0f;
        FontFamily fontFamily = FontFamily.DEFAULT;
        FontStyle fontStyle = FontStyle.NORMAL;
        float fontSize = 0.0f;
        int fill = -16777216;
        int stroke = -16777216;
        float strokeWidth = 0.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("k".equals(name)) {
                textKey = TextKey.getInstance(value);
                continue;
            }
            if ("dy".equals(name)) {
                dy = Float.parseFloat(value);
                continue;
            }
            if ("font-family".equals(name)) {
                fontFamily = FontFamily.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("font-style".equals(name)) {
                fontStyle = FontStyle.valueOf(value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            if ("font-size".equals(name)) {
                fontSize = Float.parseFloat(value);
                continue;
            }
            if ("fill".equals(name)) {
                fill = Color.parseColor((String)value);
                continue;
            }
            if ("stroke".equals(name)) {
                stroke = Color.parseColor((String)value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                strokeWidth = Float.parseFloat(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Caption.validate(elementName, textKey, fontSize, strokeWidth);
        Typeface typeface = Typeface.create((Typeface)fontFamily.toTypeface(), (int)fontStyle.toInt());
        return new Caption(textKey, dy, typeface, fontSize, fill, stroke, strokeWidth);
    }

    private static void validate(String elementName, TextKey textKey, float fontSize, float strokeWidth) {
        if (textKey == null) {
            throw new IllegalArgumentException("missing attribute k for element: " + elementName);
        }
        if (fontSize < 0.0f) {
            throw new IllegalArgumentException("font-size must not be negative: " + fontSize);
        }
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("stroke-width must not be negative: " + strokeWidth);
        }
    }

    private Caption(TextKey textKey, float dy, Typeface typeface, float fontSize, int fill, int stroke, float strokeWidth) {
        this.textKey = textKey;
        this.dy = dy;
        this.paint = new Paint(1);
        this.paint.setTextAlign(Paint.Align.LEFT);
        this.paint.setTypeface(typeface);
        this.paint.setColor(fill);
        this.stroke = new Paint(1);
        this.stroke.setStyle(Paint.Style.STROKE);
        this.stroke.setTextAlign(Paint.Align.LEFT);
        this.stroke.setTypeface(typeface);
        this.stroke.setColor(stroke);
        this.stroke.setStrokeWidth(strokeWidth);
        this.fontSize = fontSize;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
        String caption = this.textKey.getValue(tags);
        if (caption == null) {
            return;
        }
        renderCallback.renderPointOfInterestCaption(caption, this.dy, this.paint, this.stroke);
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
        String caption = this.textKey.getValue(tags);
        if (caption == null) {
            return;
        }
        renderCallback.renderAreaCaption(caption, this.dy, this.paint, this.stroke);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
        this.paint.setTextSize(this.fontSize * scaleFactor);
        this.stroke.setTextSize(this.fontSize * scaleFactor);
    }
}

