/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.Color;
import android.graphics.Paint;
import java.util.List;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class Circle
implements RenderInstruction {
    private final Paint fill;
    private final int level;
    private final Paint outline;
    private final float radius;
    private float renderRadius;
    private final boolean scaleRadius;
    private final float strokeWidth;

    public static Circle create(String elementName, Attributes attributes, int level) {
        Float radius = null;
        boolean scaleRadius = false;
        int fill = 0;
        int stroke = 0;
        float strokeWidth = 0.0f;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("r".equals(name)) {
                radius = Float.valueOf(Float.parseFloat(value));
                continue;
            }
            if ("scale-radius".equals(name)) {
                scaleRadius = Boolean.parseBoolean(value);
                continue;
            }
            if ("fill".equals(name)) {
                fill = Color.parseColor((String)value);
                continue;
            }
            if ("stroke".equals(name)) {
                stroke = Color.parseColor((String)value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                strokeWidth = Float.parseFloat(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Circle.validate(elementName, radius, strokeWidth);
        return new Circle(radius, scaleRadius, fill, stroke, strokeWidth, level);
    }

    private static void validate(String elementName, Float radius, float strokeWidth) {
        if (radius == null) {
            throw new IllegalArgumentException("missing attribute r for element: " + elementName);
        }
        if (radius.floatValue() < 0.0f) {
            throw new IllegalArgumentException("radius must not be negative: " + radius);
        }
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("stroke-width must not be negative: " + strokeWidth);
        }
    }

    private Circle(Float radius, boolean scaleRadius, int fill, int stroke, float strokeWidth, int level) {
        this.radius = radius.floatValue();
        this.scaleRadius = scaleRadius;
        if (fill == 0) {
            this.fill = null;
        } else {
            this.fill = new Paint(1);
            this.fill.setStyle(Paint.Style.FILL);
            this.fill.setColor(fill);
        }
        if (stroke == 0) {
            this.outline = null;
        } else {
            this.outline = new Paint(1);
            this.outline.setStyle(Paint.Style.STROKE);
            this.outline.setColor(stroke);
        }
        this.strokeWidth = strokeWidth;
        this.level = level;
        if (!this.scaleRadius) {
            this.renderRadius = this.radius;
            if (this.outline != null) {
                this.outline.setStrokeWidth(this.strokeWidth);
            }
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
        if (this.outline != null) {
            renderCallback.renderPointOfInterestCircle(this.renderRadius, this.outline, this.level);
        }
        if (this.fill != null) {
            renderCallback.renderPointOfInterestCircle(this.renderRadius, this.fill, this.level);
        }
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
        if (this.scaleRadius) {
            this.renderRadius = this.radius * scaleFactor;
            if (this.outline != null) {
                this.outline.setStrokeWidth(this.strokeWidth * scaleFactor);
            }
        }
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
    }
}

