/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.BitmapShader;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Shader;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.BitmapUtils;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class Line
implements RenderInstruction {
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",");
    private final int level;
    private final Paint paint;
    private final float strokeWidth;

    public static Line create(String elementName, Attributes attributes, int level, String relativePathPrefix) throws IOException {
        String src = null;
        int stroke = -16777216;
        float strokeWidth = 0.0f;
        float[] strokeDasharray = null;
        Paint.Cap strokeLinecap = Paint.Cap.ROUND;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("stroke".equals(name)) {
                stroke = Color.parseColor((String)value);
                continue;
            }
            if ("stroke-width".equals(name)) {
                strokeWidth = Float.parseFloat(value);
                continue;
            }
            if ("stroke-dasharray".equals(name)) {
                strokeDasharray = Line.parseFloatArray(value);
                continue;
            }
            if ("stroke-linecap".equals(name)) {
                strokeLinecap = Paint.Cap.valueOf((String)value.toUpperCase(Locale.ENGLISH));
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Line.validate(strokeWidth);
        return new Line(relativePathPrefix, src, stroke, strokeWidth, strokeDasharray, strokeLinecap, level);
    }

    private static void validate(float strokeWidth) {
        if (strokeWidth < 0.0f) {
            throw new IllegalArgumentException("stroke-width must not be negative: " + strokeWidth);
        }
    }

    static float[] parseFloatArray(String dashString) {
        String[] dashEntries = SPLIT_PATTERN.split(dashString);
        float[] dashIntervals = new float[dashEntries.length];
        for (int i = 0; i < dashEntries.length; ++i) {
            dashIntervals[i] = Float.parseFloat(dashEntries[i]);
        }
        return dashIntervals;
    }

    private Line(String relativePathPrefix, String src, int stroke, float strokeWidth, float[] strokeDasharray, Paint.Cap strokeLinecap, int level) throws IOException {
        BitmapShader shader = BitmapUtils.createBitmapShader(relativePathPrefix, src);
        this.paint = new Paint(1);
        this.paint.setShader((Shader)shader);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(stroke);
        if (strokeDasharray != null) {
            this.paint.setPathEffect((PathEffect)new DashPathEffect(strokeDasharray, 0.0f));
        }
        this.paint.setStrokeCap(strokeLinecap);
        this.strokeWidth = strokeWidth;
        this.level = level;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
        renderCallback.renderWay(this.paint, this.level);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
        this.paint.setStrokeWidth(this.strokeWidth * scaleFactor);
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
    }
}

