/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.Bitmap;
import java.io.IOException;
import java.util.List;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.BitmapUtils;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class LineSymbol
implements RenderInstruction {
    private final boolean alignCenter;
    private final Bitmap bitmap;
    private final boolean repeat;

    public static LineSymbol create(String elementName, Attributes attributes, String relativePathPrefix) throws IOException {
        String src = null;
        boolean alignCenter = false;
        boolean repeat = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            if ("align-center".equals(name)) {
                alignCenter = Boolean.parseBoolean(value);
                continue;
            }
            if ("repeat".equals(name)) {
                repeat = Boolean.parseBoolean(value);
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        LineSymbol.validate(elementName, src);
        return new LineSymbol(relativePathPrefix, src, alignCenter, repeat);
    }

    private static void validate(String elementName, String src) {
        if (src == null) {
            throw new IllegalArgumentException("missing attribute src for element: " + elementName);
        }
    }

    private LineSymbol(String relativePathPrefix, String src, boolean alignCenter, boolean repeat) throws IOException {
        this.bitmap = BitmapUtils.createBitmap(relativePathPrefix, src);
        this.alignCenter = alignCenter;
        this.repeat = repeat;
    }

    @Override
    public void destroy() {
        this.bitmap.recycle();
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
        renderCallback.renderWaySymbol(this.bitmap, this.alignCenter, this.repeat);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
    }
}

