/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.android.maps.rendertheme.renderinstruction;

import android.graphics.Bitmap;
import java.io.IOException;
import java.util.List;
import org.mapsforge.v3.android.maps.rendertheme.RenderCallback;
import org.mapsforge.v3.android.maps.rendertheme.RenderThemeHandler;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.BitmapUtils;
import org.mapsforge.v3.android.maps.rendertheme.renderinstruction.RenderInstruction;
import org.mapsforge.v3.core.Tag;
import org.xml.sax.Attributes;

public final class Symbol
implements RenderInstruction {
    private final Bitmap bitmap;

    public static Symbol create(String elementName, Attributes attributes, String relativePathPrefix) throws IOException {
        String src = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getLocalName(i);
            String value = attributes.getValue(i);
            if ("src".equals(name)) {
                src = value;
                continue;
            }
            RenderThemeHandler.logUnknownAttribute(elementName, name, value, i);
        }
        Symbol.validate(elementName, src);
        return new Symbol(relativePathPrefix, src);
    }

    private static void validate(String elementName, String src) {
        if (src == null) {
            throw new IllegalArgumentException("missing attribute src for element: " + elementName);
        }
    }

    private Symbol(String relativePathPrefix, String src) throws IOException {
        this.bitmap = BitmapUtils.createBitmap(relativePathPrefix, src);
    }

    @Override
    public void destroy() {
        this.bitmap.recycle();
    }

    @Override
    public void renderNode(RenderCallback renderCallback, List<Tag> tags) {
        renderCallback.renderPointOfInterestSymbol(this.bitmap);
    }

    @Override
    public void renderWay(RenderCallback renderCallback, List<Tag> tags) {
        renderCallback.renderAreaSymbol(this.bitmap);
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor) {
    }

    @Override
    public void scaleTextSize(float scaleFactor) {
    }
}

