/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.mapsforge.v3.core.MercatorProjection;

public class GeoPoint
implements Comparable<GeoPoint>,
Serializable {
    private static final double CONVERSION_FACTOR = 1000000.0;
    private static final long serialVersionUID = 1L;
    public final int latitudeE6;
    public final int longitudeE6;
    private transient int hashCodeValue;

    public GeoPoint(double latitude, double longitude) {
        double limitLatitude = MercatorProjection.limitLatitude(latitude);
        this.latitudeE6 = (int)(limitLatitude * 1000000.0);
        double limitLongitude = MercatorProjection.limitLongitude(longitude);
        this.longitudeE6 = (int)(limitLongitude * 1000000.0);
        this.hashCodeValue = this.calculateHashCode();
    }

    public GeoPoint(int latitudeE6, int longitudeE6) {
        this((double)latitudeE6 / 1000000.0, (double)longitudeE6 / 1000000.0);
    }

    @Override
    public int compareTo(GeoPoint geoPoint) {
        if (this.longitudeE6 > geoPoint.longitudeE6) {
            return 1;
        }
        if (this.longitudeE6 < geoPoint.longitudeE6) {
            return -1;
        }
        if (this.latitudeE6 > geoPoint.latitudeE6) {
            return 1;
        }
        if (this.latitudeE6 < geoPoint.latitudeE6) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoPoint)) {
            return false;
        }
        GeoPoint other = (GeoPoint)obj;
        if (this.latitudeE6 != other.latitudeE6) {
            return false;
        }
        return this.longitudeE6 == other.longitudeE6;
    }

    public double getLatitude() {
        return (double)this.latitudeE6 / 1000000.0;
    }

    public double getLongitude() {
        return (double)this.longitudeE6 / 1000000.0;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("GeoPoint [latitudeE6=");
        stringBuilder.append(this.latitudeE6);
        stringBuilder.append(", longitudeE6=");
        stringBuilder.append(this.longitudeE6);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + this.latitudeE6;
        result = 31 * result + this.longitudeE6;
        return result;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hashCodeValue = this.calculateHashCode();
    }
}

