/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.core;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;

    public static double calculateGroundResolution(double latitude, byte zoomLevel) {
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / (double)(256L << zoomLevel);
    }

    public static double latitudeToPixelY(double latitude, byte zoomLevel) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)(256L << zoomLevel);
    }

    public static long latitudeToTileY(double latitude, byte zoomLevel) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(latitude, zoomLevel), zoomLevel);
    }

    public static double limitLatitude(double latitude) {
        return Math.max(Math.min(latitude, 85.05112877980659), -85.05112877980659);
    }

    public static double limitLongitude(double longitude) {
        return Math.max(Math.min(longitude, 180.0), -180.0);
    }

    public static double longitudeToPixelX(double longitude, byte zoomLevel) {
        return (longitude + 180.0) / 360.0 * (double)(256L << zoomLevel);
    }

    public static long longitudeToTileX(double longitude, byte zoomLevel) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(longitude, zoomLevel), zoomLevel);
    }

    public static double pixelXToLongitude(double pixelX, byte zoomLevel) {
        return 360.0 * (pixelX / (double)(256L << zoomLevel) - 0.5);
    }

    public static long pixelXToTileX(double pixelX, byte zoomLevel) {
        return (long)Math.min(Math.max(pixelX / 256.0, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double pixelYToLatitude(double pixelY, byte zoomLevel) {
        double y = 0.5 - pixelY / (double)(256L << zoomLevel);
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static long pixelYToTileY(double pixelY, byte zoomLevel) {
        return (long)Math.min(Math.max(pixelY / 256.0, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double tileXToLongitude(long tileX, byte zoomLevel) {
        return MercatorProjection.pixelXToLongitude(tileX * 256L, zoomLevel);
    }

    public static double tileYToLatitude(long tileY, byte zoomLevel) {
        return MercatorProjection.pixelYToLatitude(tileY * 256L, zoomLevel);
    }

    private MercatorProjection() {
        throw new IllegalStateException();
    }
}

