/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class Tag
implements Serializable {
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final long serialVersionUID = 1L;
    public final String key;
    public final String value;
    private transient int hashCodeValue;

    public Tag(String tag) {
        int splitPosition = tag.indexOf(61);
        this.key = tag.substring(0, splitPosition);
        this.value = tag.substring(splitPosition + 1);
        this.hashCodeValue = this.calculateHashCode();
    }

    public Tag(String key, String value) {
        this.key = key;
        this.value = value;
        this.hashCodeValue = this.calculateHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        if (this.key == null && other.key != null) {
            return false;
        }
        if (this.key != null && !this.key.equals(other.key)) {
            return false;
        }
        if (this.value == null && other.value != null) {
            return false;
        }
        return this.value == null || this.value.equals(other.value);
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Tag [key=");
        stringBuilder.append(this.key);
        stringBuilder.append(", value=");
        stringBuilder.append(this.value);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private int calculateHashCode() {
        int result = 7;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hashCodeValue = this.calculateHashCode();
    }
}

