/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.map.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.v3.core.LRUCache;
import org.mapsforge.v3.map.reader.Deserializer;
import org.mapsforge.v3.map.reader.IndexCacheEntryKey;
import org.mapsforge.v3.map.reader.header.SubFileParameter;

class IndexCache {
    private static final int INDEX_ENTRIES_PER_BLOCK = 128;
    private static final Logger LOG = Logger.getLogger(IndexCache.class.getName());
    private static final int SIZE_OF_INDEX_BLOCK = 640;
    private final Map<IndexCacheEntryKey, byte[]> map;
    private final RandomAccessFile randomAccessFile;

    IndexCache(RandomAccessFile randomAccessFile, int capacity) {
        this.randomAccessFile = randomAccessFile;
        this.map = new LRUCache<IndexCacheEntryKey, byte[]>(capacity);
    }

    void destroy() {
        this.map.clear();
    }

    long getIndexEntry(SubFileParameter subFileParameter, long blockNumber) {
        try {
            if (blockNumber >= subFileParameter.numberOfBlocks) {
                return -1L;
            }
            long indexBlockNumber = blockNumber / 128L;
            IndexCacheEntryKey indexCacheEntryKey = new IndexCacheEntryKey(subFileParameter, indexBlockNumber);
            byte[] indexBlock = this.map.get(indexCacheEntryKey);
            if (indexBlock == null) {
                long indexBlockPosition = subFileParameter.indexStartAddress + indexBlockNumber * 640L;
                int remainingIndexSize = (int)(subFileParameter.indexEndAddress - indexBlockPosition);
                int indexBlockSize = Math.min(640, remainingIndexSize);
                indexBlock = new byte[indexBlockSize];
                this.randomAccessFile.seek(indexBlockPosition);
                if (this.randomAccessFile.read(indexBlock, 0, indexBlockSize) != indexBlockSize) {
                    LOG.warning("reading the current index block has failed");
                    return -1L;
                }
                this.map.put(indexCacheEntryKey, indexBlock);
            }
            long indexEntryInBlock = blockNumber % 128L;
            int addressInIndexBlock = (int)(indexEntryInBlock * 5L);
            return Deserializer.getFiveBytesLong(indexBlock, addressInIndexBlock);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, null, e);
            return -1L;
        }
    }
}

