/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.map.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.mapsforge.v3.map.reader.Deserializer;

public class ReadBuffer {
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final Logger LOG = Logger.getLogger(ReadBuffer.class.getName());
    static final int MAXIMUM_BUFFER_SIZE = 2500000;
    private byte[] bufferData;
    private int bufferPosition;
    private final RandomAccessFile inputFile;

    ReadBuffer(RandomAccessFile inputFile) {
        this.inputFile = inputFile;
    }

    public byte readByte() {
        return this.bufferData[this.bufferPosition++];
    }

    public boolean readFromFile(int length) throws IOException {
        if (this.bufferData == null || this.bufferData.length < length) {
            if (length > 2500000) {
                LOG.warning("invalid read length: " + length);
                return false;
            }
            this.bufferData = new byte[length];
        }
        this.bufferPosition = 0;
        return this.inputFile.read(this.bufferData, 0, length) == length;
    }

    public int readInt() {
        this.bufferPosition += 4;
        return Deserializer.getInt(this.bufferData, this.bufferPosition - 4);
    }

    public long readLong() {
        this.bufferPosition += 8;
        return Deserializer.getLong(this.bufferData, this.bufferPosition - 8);
    }

    public int readShort() {
        this.bufferPosition += 2;
        return Deserializer.getShort(this.bufferData, this.bufferPosition - 2);
    }

    public int readSignedInt() {
        int variableByteDecode = 0;
        int variableByteShift = 0;
        while ((this.bufferData[this.bufferPosition] & 0x80) != 0) {
            variableByteDecode |= (this.bufferData[this.bufferPosition++] & 0x7F) << variableByteShift;
            variableByteShift = (byte)(variableByteShift + 7);
        }
        if ((this.bufferData[this.bufferPosition] & 0x40) != 0) {
            return -(variableByteDecode | (this.bufferData[this.bufferPosition++] & 0x3F) << variableByteShift);
        }
        return variableByteDecode | (this.bufferData[this.bufferPosition++] & 0x3F) << variableByteShift;
    }

    public int readUnsignedInt() {
        int variableByteDecode = 0;
        int variableByteShift = 0;
        while ((this.bufferData[this.bufferPosition] & 0x80) != 0) {
            variableByteDecode |= (this.bufferData[this.bufferPosition++] & 0x7F) << variableByteShift;
            variableByteShift = (byte)(variableByteShift + 7);
        }
        return variableByteDecode | this.bufferData[this.bufferPosition++] << variableByteShift;
    }

    public String readUTF8EncodedString() {
        return this.readUTF8EncodedString(this.readUnsignedInt());
    }

    public String readUTF8EncodedString(int stringLength) {
        if (stringLength > 0 && this.bufferPosition + stringLength <= this.bufferData.length) {
            this.bufferPosition += stringLength;
            try {
                return new String(this.bufferData, this.bufferPosition - stringLength, stringLength, CHARSET_UTF8);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        LOG.warning("invalid string length: " + stringLength);
        return null;
    }

    int getBufferPosition() {
        return this.bufferPosition;
    }

    int getBufferSize() {
        return this.bufferData.length;
    }

    void setBufferPosition(int bufferPosition) {
        this.bufferPosition = bufferPosition;
    }

    void skipBytes(int bytes) {
        this.bufferPosition += bytes;
    }
}

