/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.map.reader.header;

import org.mapsforge.v3.core.GeoPoint;
import org.mapsforge.v3.map.reader.ReadBuffer;
import org.mapsforge.v3.map.reader.header.FileOpenResult;
import org.mapsforge.v3.map.reader.header.MapFileInfoBuilder;

final class OptionalFields {
    private static final int HEADER_BITMASK_COMMENT = 8;
    private static final int HEADER_BITMASK_CREATED_BY = 4;
    private static final int HEADER_BITMASK_DEBUG = 128;
    private static final int HEADER_BITMASK_LANGUAGE_PREFERENCE = 16;
    private static final int HEADER_BITMASK_START_POSITION = 64;
    private static final int HEADER_BITMASK_START_ZOOM_LEVEL = 32;
    private static final int LANGUAGE_PREFERENCE_LENGTH = 2;
    private static final int START_ZOOM_LEVEL_MAX = 22;
    String comment;
    String createdBy;
    final boolean hasComment;
    final boolean hasCreatedBy;
    final boolean hasLanguagePreference;
    final boolean hasStartPosition;
    final boolean hasStartZoomLevel;
    final boolean isDebugFile;
    String languagePreference;
    GeoPoint startPosition;
    Byte startZoomLevel;

    static FileOpenResult readOptionalFields(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        OptionalFields optionalFields;
        mapFileInfoBuilder.optionalFields = optionalFields = new OptionalFields(readBuffer.readByte());
        FileOpenResult fileOpenResult = optionalFields.readOptionalFields(readBuffer);
        if (!fileOpenResult.isSuccess()) {
            return fileOpenResult;
        }
        return FileOpenResult.SUCCESS;
    }

    private OptionalFields(byte flags) {
        this.isDebugFile = (flags & 0x80) != 0;
        this.hasStartPosition = (flags & 0x40) != 0;
        this.hasStartZoomLevel = (flags & 0x20) != 0;
        this.hasLanguagePreference = (flags & 0x10) != 0;
        this.hasComment = (flags & 8) != 0;
        this.hasCreatedBy = (flags & 4) != 0;
    }

    private FileOpenResult readLanguagePreference(ReadBuffer readBuffer) {
        if (this.hasLanguagePreference) {
            String countryCode = readBuffer.readUTF8EncodedString();
            if (countryCode.length() != 2) {
                return new FileOpenResult("invalid language preference: " + countryCode);
            }
            this.languagePreference = countryCode;
        }
        return FileOpenResult.SUCCESS;
    }

    private FileOpenResult readMapStartPosition(ReadBuffer readBuffer) {
        if (this.hasStartPosition) {
            int mapStartLatitude = readBuffer.readInt();
            if (mapStartLatitude < -90000000 || mapStartLatitude > 90000000) {
                return new FileOpenResult("invalid map start latitude: " + mapStartLatitude);
            }
            int mapStartLongitude = readBuffer.readInt();
            if (mapStartLongitude < -180000000 || mapStartLongitude > 180000000) {
                return new FileOpenResult("invalid map start longitude: " + mapStartLongitude);
            }
            this.startPosition = new GeoPoint(mapStartLatitude, mapStartLongitude);
        }
        return FileOpenResult.SUCCESS;
    }

    private FileOpenResult readMapStartZoomLevel(ReadBuffer readBuffer) {
        if (this.hasStartZoomLevel) {
            byte mapStartZoomLevel = readBuffer.readByte();
            if (mapStartZoomLevel < 0 || mapStartZoomLevel > 22) {
                return new FileOpenResult("invalid map start zoom level: " + mapStartZoomLevel);
            }
            this.startZoomLevel = mapStartZoomLevel;
        }
        return FileOpenResult.SUCCESS;
    }

    private FileOpenResult readOptionalFields(ReadBuffer readBuffer) {
        FileOpenResult fileOpenResult = this.readMapStartPosition(readBuffer);
        if (!fileOpenResult.isSuccess()) {
            return fileOpenResult;
        }
        fileOpenResult = this.readMapStartZoomLevel(readBuffer);
        if (!fileOpenResult.isSuccess()) {
            return fileOpenResult;
        }
        fileOpenResult = this.readLanguagePreference(readBuffer);
        if (!fileOpenResult.isSuccess()) {
            return fileOpenResult;
        }
        if (this.hasComment) {
            this.comment = readBuffer.readUTF8EncodedString();
        }
        if (this.hasCreatedBy) {
            this.createdBy = readBuffer.readUTF8EncodedString();
        }
        return FileOpenResult.SUCCESS;
    }
}

