/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.v3.map.reader.header;

import java.io.IOException;
import org.mapsforge.v3.core.BoundingBox;
import org.mapsforge.v3.core.Tag;
import org.mapsforge.v3.map.reader.ReadBuffer;
import org.mapsforge.v3.map.reader.header.FileOpenResult;
import org.mapsforge.v3.map.reader.header.MapFileInfoBuilder;

final class RequiredFields {
    private static final String BINARY_OSM_MAGIC_BYTE = "mapsforge binary OSM";
    private static final int HEADER_SIZE_MAX = 1000000;
    private static final int HEADER_SIZE_MIN = 70;
    private static final String MERCATOR = "Mercator";
    private static final char SPACE = ' ';
    private static final int SUPPORTED_FILE_VERSION = 3;
    static final int LATITUDE_MAX = 90000000;
    static final int LATITUDE_MIN = -90000000;
    static final int LONGITUDE_MAX = 180000000;
    static final int LONGITUDE_MIN = -180000000;

    static FileOpenResult readBoundingBox(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int minLatitude = readBuffer.readInt();
        if (minLatitude < -90000000 || minLatitude > 90000000) {
            return new FileOpenResult("invalid minimum latitude: " + minLatitude);
        }
        int minLongitude = readBuffer.readInt();
        if (minLongitude < -180000000 || minLongitude > 180000000) {
            return new FileOpenResult("invalid minimum longitude: " + minLongitude);
        }
        int maxLatitude = readBuffer.readInt();
        if (maxLatitude < -90000000 || maxLatitude > 90000000) {
            return new FileOpenResult("invalid maximum latitude: " + maxLatitude);
        }
        int maxLongitude = readBuffer.readInt();
        if (maxLongitude < -180000000 || maxLongitude > 180000000) {
            return new FileOpenResult("invalid maximum longitude: " + maxLongitude);
        }
        if (minLatitude > maxLatitude) {
            return new FileOpenResult("invalid latitude range: " + minLatitude + ' ' + maxLatitude);
        }
        if (minLongitude > maxLongitude) {
            return new FileOpenResult("invalid longitude range: " + minLongitude + ' ' + maxLongitude);
        }
        mapFileInfoBuilder.boundingBox = new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readFileSize(ReadBuffer readBuffer, long fileSize, MapFileInfoBuilder mapFileInfoBuilder) {
        long headerFileSize = readBuffer.readLong();
        if (headerFileSize != fileSize) {
            return new FileOpenResult("invalid file size: " + headerFileSize);
        }
        mapFileInfoBuilder.fileSize = fileSize;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readFileVersion(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int fileVersion = readBuffer.readInt();
        if (fileVersion != 3) {
            return new FileOpenResult("unsupported file version: " + fileVersion);
        }
        mapFileInfoBuilder.fileVersion = fileVersion;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readMagicByte(ReadBuffer readBuffer) throws IOException {
        int magicByteLength = BINARY_OSM_MAGIC_BYTE.length();
        if (!readBuffer.readFromFile(magicByteLength + 4)) {
            return new FileOpenResult("reading magic byte has failed");
        }
        String magicByte = readBuffer.readUTF8EncodedString(magicByteLength);
        if (!BINARY_OSM_MAGIC_BYTE.equals(magicByte)) {
            return new FileOpenResult("invalid magic byte: " + magicByte);
        }
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readMapDate(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        long mapDate = readBuffer.readLong();
        if (mapDate < 1200000000000L) {
            return new FileOpenResult("invalid map date: " + mapDate);
        }
        mapFileInfoBuilder.mapDate = mapDate;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readPoiTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfPoiTags = readBuffer.readShort();
        if (numberOfPoiTags < 0) {
            return new FileOpenResult("invalid number of POI tags: " + numberOfPoiTags);
        }
        Tag[] poiTags = new Tag[numberOfPoiTags];
        for (int currentTagId = 0; currentTagId < numberOfPoiTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                return new FileOpenResult("POI tag must not be null: " + currentTagId);
            }
            poiTags[currentTagId] = new Tag(tag);
        }
        mapFileInfoBuilder.poiTags = poiTags;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readProjectionName(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        String projectionName = readBuffer.readUTF8EncodedString();
        if (!MERCATOR.equals(projectionName)) {
            return new FileOpenResult("unsupported projection: " + projectionName);
        }
        mapFileInfoBuilder.projectionName = projectionName;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readRemainingHeader(ReadBuffer readBuffer) throws IOException {
        int remainingHeaderSize = readBuffer.readInt();
        if (remainingHeaderSize < 70 || remainingHeaderSize > 1000000) {
            return new FileOpenResult("invalid remaining header size: " + remainingHeaderSize);
        }
        if (!readBuffer.readFromFile(remainingHeaderSize)) {
            return new FileOpenResult("reading header data has failed: " + remainingHeaderSize);
        }
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readTilePixelSize(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int tilePixelSize = readBuffer.readShort();
        if (tilePixelSize != 256) {
            return new FileOpenResult("unsupported tile pixel size: " + tilePixelSize);
        }
        mapFileInfoBuilder.tilePixelSize = tilePixelSize;
        return FileOpenResult.SUCCESS;
    }

    static FileOpenResult readWayTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfWayTags = readBuffer.readShort();
        if (numberOfWayTags < 0) {
            return new FileOpenResult("invalid number of way tags: " + numberOfWayTags);
        }
        Tag[] wayTags = new Tag[numberOfWayTags];
        for (int currentTagId = 0; currentTagId < numberOfWayTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                return new FileOpenResult("way tag must not be null: " + currentTagId);
            }
            wayTags[currentTagId] = new Tag(tag);
        }
        mapFileInfoBuilder.wayTags = wayTags;
        return FileOpenResult.SUCCESS;
    }

    private RequiredFields() {
        throw new IllegalStateException();
    }
}

