/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.graphics;

import org.mapsforge.core.graphics.Filter;

public final class GraphicUtils {
    public static int filterColor(int color, Filter filter) {
        if (filter == Filter.NONE) {
            return color;
        }
        int a = color >>> 24;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        switch (filter) {
            case GRAYSCALE: {
                g = b = (int)(0.213f * (float)r + 0.715f * (float)g + 0.072f * (float)b);
                r = b;
                break;
            }
            case GRAYSCALE_INVERT: {
                g = b = 255 - (int)(0.213f * (float)r + 0.715f * (float)g + 0.072f * (float)b);
                r = b;
                break;
            }
            case INVERT: {
                r = 255 - r;
                g = 255 - g;
                b = 255 - b;
            }
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }

    private GraphicUtils() {
    }
}

