/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapsforge.core.util.LatLongUtils;

public class LatLong
implements Comparable<LatLong> {
    private static final Pattern WKT_POINT_PATTERN = Pattern.compile(".*POINT\\s?\\(([\\d\\.]+)\\s([\\d\\.]+)\\).*");
    public final double latitude;
    public final double longitude;

    public LatLong(double latitude, double longitude) throws IllegalArgumentException {
        this.latitude = LatLongUtils.validateLatitude(latitude);
        this.longitude = LatLongUtils.validateLongitude(longitude);
    }

    public LatLong(String wellKnownText) {
        Matcher m = WKT_POINT_PATTERN.matcher(wellKnownText);
        m.matches();
        this.longitude = LatLongUtils.validateLongitude(Double.parseDouble(m.group(1)));
        this.latitude = LatLongUtils.validateLatitude(Double.parseDouble(m.group(2)));
    }

    @Override
    public int compareTo(LatLong latLong) {
        if (this.latitude > latLong.latitude || this.longitude > latLong.longitude) {
            return 1;
        }
        if (this.latitude < latLong.latitude || this.longitude < latLong.longitude) {
            return -1;
        }
        return 0;
    }

    public LatLong destinationPoint(double distance, float bearing) {
        return LatLongUtils.destinationPoint(this, distance, bearing);
    }

    public double distance(LatLong other) {
        return LatLongUtils.distance(this, other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LatLong)) {
            return false;
        }
        LatLong other = (LatLong)obj;
        if (this.latitude != other.latitude) {
            return false;
        }
        return this.longitude == other.longitude;
    }

    public static LatLong fromMicroDegrees(int latitudeE6, int longitudeE6) {
        return new LatLong(LatLongUtils.microdegreesToDegrees(latitudeE6), LatLongUtils.microdegreesToDegrees(longitudeE6));
    }

    public static LatLong fromString(String latLonString) {
        String[] split = latLonString.split("[,;:\\s]");
        if (split.length != 2) {
            throw new IllegalArgumentException("cannot read coordinate, not a valid format");
        }
        double latitude = Double.parseDouble(split[0]);
        double longitude = Double.parseDouble(split[1]);
        return new LatLong(latitude, longitude);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getLatitudeE6() {
        return LatLongUtils.degreesToMicrodegrees(this.latitude);
    }

    public double getLongitude() {
        return this.longitude;
    }

    public int getLongitudeE6() {
        return LatLongUtils.degreesToMicrodegrees(this.longitude);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public double sphericalDistance(LatLong other) {
        return LatLongUtils.sphericalDistance(this, other);
    }

    public String toString() {
        return "latitude=" + this.latitude + ", longitude=" + this.longitude;
    }

    public double vincentyDistance(LatLong other) {
        return LatLongUtils.vincentyDistance(this, other);
    }
}

