/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;

public final class LineSegment {
    private static int INSIDE = 0;
    private static int LEFT = 1;
    private static int RIGHT = 2;
    private static int BOTTOM = 4;
    private static int TOP = 8;
    public final Point start;
    public final Point end;

    public LineSegment(Point start, Point end) {
        this.start = start;
        this.end = end;
    }

    public LineSegment(Point start, Point direction, double distance) {
        this.start = start;
        this.end = new LineSegment(start, direction).pointAlongLineSegment(distance);
    }

    public LineSegment clipToRectangle(Rectangle r) {
        Point a = this.start;
        Point b = this.end;
        int codeStart = LineSegment.code(r, a);
        int codeEnd = LineSegment.code(r, b);
        while (0 != (codeStart | codeEnd)) {
            double newY;
            double newX;
            int outsideCode;
            if (0 != (codeStart & codeEnd)) {
                return null;
            }
            int n = outsideCode = 0 != codeStart ? codeStart : codeEnd;
            if (0 != (outsideCode & TOP)) {
                newX = a.x + (b.x - a.x) * (r.top - a.y) / (b.y - a.y);
                newY = r.top;
            } else if (0 != (outsideCode & BOTTOM)) {
                newX = a.x + (b.x - a.x) * (r.bottom - a.y) / (b.y - a.y);
                newY = r.bottom;
            } else if (0 != (outsideCode & RIGHT)) {
                newY = a.y + (b.y - a.y) * (r.right - a.x) / (b.x - a.x);
                newX = r.right;
            } else if (0 != (outsideCode & LEFT)) {
                newY = a.y + (b.y - a.y) * (r.left - a.x) / (b.x - a.x);
                newX = r.left;
            } else {
                throw new IllegalStateException("Should not get here");
            }
            if (outsideCode == codeStart) {
                a = new Point(newX, newY);
                codeStart = LineSegment.code(r, a);
                continue;
            }
            b = new Point(newX, newY);
            codeEnd = LineSegment.code(r, b);
        }
        return new LineSegment(a, b);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LineSegment)) {
            return false;
        }
        LineSegment other = (LineSegment)obj;
        return other.start.equals(this.start) && other.end.equals(this.end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        return result;
    }

    public boolean intersectsRectangle(Rectangle r, boolean bias) {
        int codeEnd;
        int codeStart = LineSegment.code(r, this.start);
        if (0 == (codeStart | (codeEnd = LineSegment.code(r, this.end)))) {
            return true;
        }
        if (0 != (codeStart & codeEnd)) {
            return false;
        }
        return bias;
    }

    public double length() {
        return this.start.distance(this.end);
    }

    public Point pointAlongLineSegment(double distance) {
        if (this.start.x == this.end.x) {
            if (this.start.y > this.end.y) {
                return new Point(this.end.x, this.end.y + distance);
            }
            return new Point(this.start.x, this.start.y + distance);
        }
        double slope = (this.end.y - this.start.y) / (this.end.x - this.start.x);
        double dx = Math.sqrt(distance * distance / (1.0 + slope * slope));
        if (this.end.x < this.start.x) {
            dx *= -1.0;
        }
        return new Point(this.start.x + dx, this.start.y + slope * dx);
    }

    public LineSegment reverse() {
        return new LineSegment(this.end, this.start);
    }

    public LineSegment subSegment(double offset, double length) {
        Point subSegmentStart = this.pointAlongLineSegment(offset);
        Point subSegmentEnd = this.pointAlongLineSegment(offset + length);
        return new LineSegment(subSegmentStart, subSegmentEnd);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.start).append(" ").append(this.end);
        return stringBuilder.toString();
    }

    private static int code(Rectangle r, Point p) {
        int code = INSIDE;
        if (p.x < r.left) {
            code |= LEFT;
        } else if (p.x > r.right) {
            code |= RIGHT;
        }
        if (p.y > r.bottom) {
            code |= BOTTOM;
        } else if (p.y < r.top) {
            code |= TOP;
        }
        return code;
    }
}

