/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.zzd;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzx;
import java.io.IOException;
import java.util.List;

public final class GoogleAuthUtil
extends zzd {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_CALLER_UID = zzd.KEY_CALLER_UID;
    public static final String KEY_ANDROID_PACKAGE_NAME = zzd.KEY_ANDROID_PACKAGE_NAME;
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, callback);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, authority, syncBundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zza(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zza(Context context, Account account, String string2, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzb(context, account, string2, bundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.zzi((Intent)callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        zzx.zzh((String)authority, (Object)"Authority cannot be empty or null.");
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, scope, extras);
        return tokenData.getToken();
    }

    private static TokenData zzb(Context context, Account account, String string2, Bundle bundle) throws IOException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            TokenData tokenData = GoogleAuthUtil.zzc((Context)context, (Account)account, (String)string2, (Bundle)bundle);
            GooglePlayServicesUtil.zzal((Context)context);
            return tokenData;
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            GooglePlayServicesUtil.showErrorNotification(n, context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.zzal((Context)context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private GoogleAuthUtil() {
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (String)accountName, (String)scope);
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (String)accountName, (String)scope, (Bundle)extras);
    }

    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (Account)account, (String)scope);
    }

    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return zzd.getToken((Context)context, (Account)account, (String)scope, (Bundle)extras);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_ACCOUNTS")
    public static void invalidateToken(Context context, String token) {
        zzd.invalidateToken((Context)context, (String)token);
    }

    public static void clearToken(Context context, String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        zzd.clearToken((Context)context, (String)token);
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context context, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        return zzd.getAccountChangeEvents((Context)context, (int)eventIndex, (String)accountName);
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        return zzd.getAccountId((Context)ctx, (String)accountName);
    }
}

