/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.generation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.process.OriginatingElements;

public class ApiCodeGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiCodeGenerator.class);
    private static final byte[] BUFFER = new byte[4096];
    private final Filer filer;

    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int read;
        while ((read = input.read(BUFFER)) != -1) {
            output.write(BUFFER, 0, read);
        }
    }

    public ApiCodeGenerator(Filer filer) {
        this.filer = filer;
    }

    public void writeApiClasses(Set<Class<?>> apiClassesToGenerate, OriginatingElements originatingElements) {
        LOGGER.info("Writting following API classes in project: {}", apiClassesToGenerate);
        for (Class<?> apiClassToGenerate : apiClassesToGenerate) {
            String canonicalApiClassName = apiClassToGenerate.getCanonicalName();
            String apiClassFileName = canonicalApiClassName.replace(".", "/") + ".java";
            InputStream apiClassStream = this.getClass().getClassLoader().getResourceAsStream(apiClassFileName);
            try {
                if (apiClassStream == null) {
                    apiClassStream = this.getClass().getClassLoader().getResourceAsStream('/' + apiClassFileName);
                }
                Element[] apiClassOriginatingElements = originatingElements.getClassOriginatingElements(canonicalApiClassName);
                try {
                    JavaFileObject targetedClassFile = apiClassOriginatingElements == null ? this.filer.createSourceFile(canonicalApiClassName, new Element[0]) : this.filer.createSourceFile(canonicalApiClassName, apiClassOriginatingElements);
                    OutputStream classFileOutputStream = targetedClassFile.openOutputStream();
                    ApiCodeGenerator.copyStream(apiClassStream, classFileOutputStream);
                    classFileOutputStream.close();
                }
                catch (FilerException filerException) {}
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

