/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.generation;

import com.sun.codemodel.writer.PrologCodeWriter;
import java.io.IOException;
import javax.annotation.processing.Filer;
import org.androidannotations.generation.ApiCodeGenerator;
import org.androidannotations.generation.ResourceCodeWriter;
import org.androidannotations.generation.SourceCodewriter;
import org.androidannotations.process.ModelProcessor;

public class CodeModelGenerator {
    private final Filer filer;
    private final String header;

    public CodeModelGenerator(Filer filer, String aaVersion) {
        this.filer = filer;
        this.header = "DO NOT EDIT THIS FILE.Generated using AndroidAnnotations " + aaVersion + ".\n " + "You can create a larger work that contains this file and distribute that work under terms of your choice.\n";
    }

    public void generate(ModelProcessor.ProcessResult processResult) throws IOException {
        ApiCodeGenerator apiCodeGenerator = new ApiCodeGenerator(this.filer);
        apiCodeGenerator.writeApiClasses(processResult.apiClassesToGenerate, processResult.originatingElements);
        SourceCodewriter sourceCodeWriter = new SourceCodewriter(this.filer, processResult.originatingElements);
        PrologCodeWriter prologCodeWriter = new PrologCodeWriter(sourceCodeWriter, this.header);
        processResult.codeModel.build(prologCodeWriter, new ResourceCodeWriter(this.filer));
    }
}

