/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JFieldRef;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.CustomTitle;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class CustomTitleHandler
extends BaseAnnotationHandler<EActivityHolder> {
    private final AnnotationHelper annotationHelper;

    public CustomTitleHandler(ProcessingEnvironment processingEnvironment) {
        super(CustomTitle.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasEActivity(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) {
        JBlock onViewChangedBody = holder.getOnViewChangedBody();
        JFieldRef contentViewId = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, this.getTarget(), this.rClass.get(IRClass.Res.LAYOUT), false).get(0);
        JFieldRef customTitleFeature = this.classes().WINDOW.staticRef("FEATURE_CUSTOM_TITLE");
        holder.getInitBody().invoke("requestWindowFeature").arg(customTitleFeature);
        onViewChangedBody.add(holder.getContextRef().invoke("getWindow").invoke("setFeatureInt").arg(customTitleFeature).arg(contentViewId));
    }
}

