/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JVar;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import org.androidannotations.annotations.OptionsMenu;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.HasOptionsMenu;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class OptionsMenuHandler
extends BaseAnnotationHandler<HasOptionsMenu> {
    private IdAnnotationHelper annotationHelper;

    public OptionsMenuHandler(ProcessingEnvironment processingEnvironment) {
        super(OptionsMenu.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.annotationHelper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.hasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.MENU, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
    }

    @Override
    public void process(Element element, HasOptionsMenu holder) {
        JBlock body = holder.getOnCreateOptionsMenuMethodBody();
        JVar menuInflater = holder.getOnCreateOptionsMenuMenuInflaterVar();
        JVar menuParam = holder.getOnCreateOptionsMenuMenuParam();
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.MENU, false);
        for (JFieldRef optionsMenuRefId : fieldRefs) {
            body.invoke((JExpression)menuInflater, "inflate").arg(optionsMenuRefId).arg(menuParam);
        }
    }
}

