/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCatchBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.Transactional;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class TransactionalHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public TransactionalHandler(ProcessingEnvironment processingEnvironment) {
        super(Transactional.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.doesntThrowException(executableElement, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.param.hasOneOrTwoParametersAndFirstIsDb(executableElement, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        String returnTypeName = executableElement.getReturnType().toString();
        JClass returnType = this.refClass(returnTypeName);
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        this.codeModelHelper.removeBody(method);
        JVar db = method.params().get(0);
        JBlock body = method.body();
        body.invoke((JExpression)db, "beginTransaction");
        JTryBlock tryBlock = body._try();
        JFieldRef activitySuper = holder.getGeneratedClass().staticRef("super");
        JInvocation superCall = JExpr.invoke((JExpression)activitySuper, method);
        for (JVar param : method.params()) {
            superCall.arg(param);
        }
        JBlock tryBody = tryBlock.body();
        if (returnTypeName.equals("void")) {
            tryBody.add(superCall);
            tryBody.invoke((JExpression)db, "setTransactionSuccessful");
            tryBody._return();
        } else {
            JVar result = tryBody.decl(returnType, "result_", superCall);
            tryBody.invoke((JExpression)db, "setTransactionSuccessful");
            tryBody._return(result);
        }
        JCatchBlock catchBlock = tryBlock._catch(this.refClass(RuntimeException.class));
        JVar exceptionParam = catchBlock.param("e");
        JBlock catchBody = catchBlock.body();
        JInvocation errorInvoke = catchBody.staticInvoke(this.classes().LOG, "e");
        errorInvoke.arg(holder.getGeneratedClass().name());
        errorInvoke.arg("Error in transaction");
        errorInvoke.arg(exceptionParam);
        catchBody._throw(exceptionParam);
        tryBlock._finally().invoke((JExpression)db, "endTransaction");
    }
}

