/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.ViewsById;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.IdAnnotationHelper;
import org.androidannotations.helper.IdValidatorHelper;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.model.AndroidSystemServices;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;
import org.androidannotations.rclass.IRClass;

public class ViewsByIdHandler
extends BaseAnnotationHandler<EComponentWithViewSupportHolder> {
    private IdAnnotationHelper helper;
    private APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public ViewsByIdHandler(ProcessingEnvironment processingEnvironment) {
        super(ViewsById.class, processingEnvironment);
    }

    @Override
    public void setAndroidEnvironment(IRClass rClass, AndroidSystemServices androidSystemServices, AndroidManifest androidManifest) {
        super.setAndroidEnvironment(rClass, androidSystemServices, androidManifest);
        this.helper = new IdAnnotationHelper(this.processingEnv, this.getTarget(), rClass);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.isDeclaredType(element, valid);
        this.validatorHelper.extendsListOfView(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.NEED_RES_ID, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EComponentWithViewSupportHolder holder) {
        JFieldRef elementRef = JExpr.ref(element.getSimpleName().toString());
        TypeMirror viewType = this.extractViewClass(element);
        JClass viewClass = this.codeModelHelper.typeMirrorToJClass(viewType, holder);
        this.instantiateArrayList(elementRef, viewType, holder);
        this.clearList(elementRef, holder);
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(this.processHolder, element, IRClass.Res.ID, true);
        for (JFieldRef idRef : idsRefs) {
            this.addViewToListIfNotNull(elementRef, viewClass, idRef, holder);
        }
    }

    private void instantiateArrayList(JFieldRef elementRef, TypeMirror viewType, EComponentWithViewSupportHolder holder) {
        TypeElement arrayListTypeElement = this.helper.typeElementFromQualifiedName(CanonicalNameConstants.ARRAYLIST);
        DeclaredType arrayListType = this.helper.getTypeUtils().getDeclaredType(arrayListTypeElement, viewType);
        JClass arrayListClass = this.codeModelHelper.typeMirrorToJClass(arrayListType, holder);
        holder.getInitBody().assign(elementRef, JExpr._new(arrayListClass));
    }

    private TypeMirror extractViewClass(Element element) {
        DeclaredType elementType = (DeclaredType)element.asType();
        List<? extends TypeMirror> elementTypeArguments = elementType.getTypeArguments();
        TypeMirror viewType = this.helper.typeElementFromQualifiedName("android.view.View").asType();
        if (!elementTypeArguments.isEmpty()) {
            viewType = elementTypeArguments.get(0);
        }
        return viewType;
    }

    private void clearList(JFieldRef elementRef, EComponentWithViewSupportHolder holder) {
        holder.getOnViewChangedBodyBeforeFindViews().add(elementRef.invoke("clear"));
    }

    private void addViewToListIfNotNull(JFieldRef elementRef, JClass viewClass, JFieldRef idRef, EComponentWithViewSupportHolder holder) {
        FoundViewHolder foundViewHolder = holder.getFoundViewHolder(idRef, viewClass);
        foundViewHolder.getIfNotNullBlock().invoke((JExpression)elementRef, "add").arg(foundViewHolder.getOrCastRef(viewClass));
    }
}

