/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JTryBlock;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.androidannotations.annotations.WakeLock;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class WakeLockHandler
extends BaseAnnotationHandler<EComponentHolder> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public WakeLockHandler(ProcessingEnvironment processingEnvironment) {
        super(WakeLock.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEnhancedComponentAnnotation(element, validatedElements, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.doesNotHaveTraceAnnotationAndReturnValue(executableElement, validatedElements, valid);
        this.validatorHelper.doesNotUseFlagsWithPartialWakeLock(element, validatedElements, valid);
        this.validatorHelper.hasWakeLockPermission(element, this.androidManifest, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.isNotFinal(element, valid);
    }

    @Override
    public void process(Element element, EComponentHolder holder) {
        ExecutableElement executableElement = (ExecutableElement)element;
        WakeLock annotation = executableElement.getAnnotation(WakeLock.class);
        String tag = this.extractTag(executableElement);
        WakeLock.Level level = annotation.level();
        WakeLock.Flag[] flags = annotation.flags();
        JMethod method = this.codeModelHelper.overrideAnnotatedMethod(executableElement, holder);
        JBlock previousMethodBody = this.codeModelHelper.removeBody(method);
        JBlock methodBody = method.body();
        JExpression levelAndFlags = this.classes().POWER_MANAGER.staticRef(level.name());
        if (flags.length > 0) {
            for (WakeLock.Flag flag : flags) {
                levelAndFlags = levelAndFlags.bor(this.classes().POWER_MANAGER.staticRef(flag.name()));
            }
        }
        JInvocation newWakeLock = holder.getPowerManagerRef().invoke("newWakeLock").arg(levelAndFlags).arg(JExpr.lit(tag));
        JVar wakeLock = methodBody.decl(this.classes().WAKE_LOCK, "wakeLock", JExpr._null());
        JTryBlock tryBlock = methodBody._try();
        tryBlock.body().assign(wakeLock, newWakeLock);
        tryBlock.body().add(wakeLock.invoke("acquire"));
        tryBlock.body().add(previousMethodBody);
        JBlock finallyBlock = tryBlock._finally();
        JConditional ifStatement = finallyBlock._if(wakeLock.ne(JExpr._null()));
        ifStatement._then().add(wakeLock.invoke("release"));
    }

    private String extractTag(Element element) {
        WakeLock annotation = element.getAnnotation(WakeLock.class);
        String tag = annotation.tag();
        if ("NO_TAG".equals(tag)) {
            tag = element.getEnclosingElement().getSimpleName().toString() + "." + element.getSimpleName().toString();
        }
        return tag;
    }
}

