/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.CanonicalNameConstants;
import org.androidannotations.helper.Pair;
import org.androidannotations.holder.HasIntentBuilder;

public abstract class IntentBuilder {
    protected HasIntentBuilder holder;
    protected AndroidManifest androidManifest;
    protected JDefinedClass builderClass;
    protected JFieldRef contextField;
    protected JFieldRef intentField;
    protected JClass contextClass;
    protected JClass intentClass;
    protected Map<Pair<TypeMirror, String>, JMethod> putExtraMethods = new HashMap<Pair<TypeMirror, String>, JMethod>();
    protected Elements elementUtils;
    protected Types typeUtils;
    protected APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    public IntentBuilder(HasIntentBuilder holder, AndroidManifest androidManifest) {
        this.holder = holder;
        this.androidManifest = androidManifest;
        this.elementUtils = holder.processingEnvironment().getElementUtils();
        this.typeUtils = holder.processingEnvironment().getTypeUtils();
        this.contextClass = holder.classes().CONTEXT;
        this.intentClass = holder.classes().INTENT;
    }

    public void build() throws JClassAlreadyExistsException {
        this.createClass();
        this.createContextConstructor();
        this.createIntentMethod();
    }

    private void createClass() throws JClassAlreadyExistsException {
        this.builderClass = this.holder.getGeneratedClass()._class(17, "IntentBuilder_");
        this.builderClass._extends(this.getSuperClass());
        this.holder.setIntentBuilderClass(this.builderClass);
        this.contextField = JExpr.ref("context");
        this.intentField = JExpr.ref("intent");
    }

    private void createContextConstructor() {
        JExpression generatedClass = this.holder.getGeneratedClass().dotclass();
        JMethod constructor = this.holder.getIntentBuilderClass().constructor(1);
        JVar constructorContextParam = constructor.param(this.holder.classes().CONTEXT, "context");
        constructor.body().invoke("super").arg(constructorContextParam).arg(generatedClass);
    }

    private void createIntentMethod() {
        JMethod method = this.holder.getGeneratedClass().method(17, this.holder.getIntentBuilderClass(), "intent");
        JVar contextParam = method.param(this.contextClass, "context");
        method.body()._return(JExpr._new(this.holder.getIntentBuilderClass()).arg(contextParam));
    }

    public JMethod getPutExtraMethod(TypeMirror elementType, String parameterName, JFieldVar extraKeyField) {
        Pair<TypeMirror, String> signature = new Pair<TypeMirror, String>(elementType, parameterName);
        JMethod putExtraMethod = this.putExtraMethods.get(signature);
        if (putExtraMethod == null) {
            putExtraMethod = this.addPutExtraMethod(elementType, parameterName, extraKeyField);
            this.putExtraMethods.put(signature, putExtraMethod);
        }
        return putExtraMethod;
    }

    private JMethod addPutExtraMethod(TypeMirror elementType, String parameterName, JFieldVar extraKeyField) {
        JMethod method = this.holder.getIntentBuilderClass().method(1, this.holder.getIntentBuilderClass(), parameterName);
        JClass parameterClass = this.codeModelHelper.typeMirrorToJClass(elementType, this.holder);
        JVar extraParameterVar = method.param(parameterClass, parameterName);
        JInvocation superCall = this.getSuperPutExtraInvocation(elementType, extraParameterVar, extraKeyField);
        method.body()._return(superCall);
        return method;
    }

    public JInvocation getSuperPutExtraInvocation(TypeMirror elementType, JVar extraParam, JFieldVar extraKeyField) {
        JExpressionImpl extraParameterArg = extraParam;
        if (elementType.getKind() == TypeKind.DECLARED) {
            Elements elementUtils = this.holder.processingEnvironment().getElementUtils();
            TypeMirror parcelableType = elementUtils.getTypeElement("android.os.Parcelable").asType();
            if (!this.typeUtils.isSubtype(elementType, parcelableType)) {
                TypeMirror stringType = elementUtils.getTypeElement(CanonicalNameConstants.STRING).asType();
                if (!this.typeUtils.isSubtype(elementType, stringType)) {
                    extraParameterArg = JExpr.cast(this.holder.classes().SERIALIZABLE, extraParameterArg);
                }
            } else {
                TypeMirror serializableType = elementUtils.getTypeElement(CanonicalNameConstants.SERIALIZABLE).asType();
                if (this.typeUtils.isSubtype(elementType, serializableType)) {
                    extraParameterArg = JExpr.cast(this.holder.classes().PARCELABLE, extraParameterArg);
                }
            }
        }
        return JExpr._super().invoke("extra").arg(extraKeyField).arg(extraParameterArg);
    }

    protected abstract JClass getSuperClass();
}

