/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import org.androidannotations.logger.Level;

public class OptionsHelper {
    private final Map<String, String> options;

    public OptionsHelper(ProcessingEnvironment processingEnvironment) {
        this.options = processingEnvironment.getOptions();
    }

    public static Set<String> getOptionsConstants() {
        TreeSet<String> set = new TreeSet<String>();
        for (Option optionEnum : Option.values()) {
            set.add(optionEnum.getKey());
        }
        return set;
    }

    public boolean shouldLogTrace() {
        return this.getBoolean(Option.TRACE);
    }

    public boolean shouldEnsureThreadControl() {
        return this.getBoolean(Option.THREAD_CONTROL);
    }

    public String getAndroidManifestFile() {
        return this.getString(Option.ANDROID_MANIFEST_FILE);
    }

    public String getResourcePackageName() {
        return this.getString(Option.RESOURCE_PACKAGE_NAME);
    }

    public String getLogFile() {
        return this.getString(Option.LOG_FILE);
    }

    public Level getLogLevel() {
        try {
            return Level.parse(this.getString(Option.LOG_LEVEL));
        }
        catch (Exception e) {
            return Level.parse(Option.LOG_LEVEL.getDefaultValue());
        }
    }

    public boolean shouldUseConsoleAppender() {
        return this.getBoolean(Option.LOG_APPENDER_CONSOLE);
    }

    public boolean shouldUseFileAppender() {
        return this.getBoolean(Option.LOG_APPENDER_FILE);
    }

    private String getString(Option option) {
        String key = option.getKey();
        if (this.options.containsKey(key)) {
            return this.options.get(key);
        }
        return option.getDefaultValue();
    }

    private boolean getBoolean(Option option) {
        return Boolean.valueOf(this.getString(option));
    }

    static enum Option {
        TRACE("trace", "false"),
        THREAD_CONTROL("threadControl", "true"),
        ANDROID_MANIFEST_FILE("androidManifestFile", null),
        RESOURCE_PACKAGE_NAME("resourcePackageName", null),
        LOG_FILE("logFile", null),
        LOG_LEVEL("logLevel", "DEBUG"),
        LOG_APPENDER_CONSOLE("logAppenderConsole", "false"),
        LOG_APPENDER_FILE("logAppenderFile", "true");

        private String key;
        private String defaultValue;

        private Option(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

