/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.helper;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.androidannotations.helper.TargetAnnotationHelper;
import org.androidannotations.holder.HasLifecycleMethods;
import org.androidannotations.process.ProcessHolder;

public class OrmLiteHelper {
    private final TargetAnnotationHelper helper;
    private DeclaredType daoParametrizedType;
    private DeclaredType runtimeExceptionDaoParametrizedType;
    private TypeElement daoTypeElement;
    private TypeElement runtimeExceptionDaoTypeElement;

    public OrmLiteHelper(TargetAnnotationHelper helper) {
        this.helper = helper;
    }

    public TypeMirror getEntityType(Element element) {
        return this.getEntityOrIdType(element, 0);
    }

    public TypeMirror getEntityIdType(Element element) {
        return this.getEntityOrIdType(element, 1);
    }

    private TypeMirror getEntityOrIdType(Element element, int index) {
        DeclaredType declaredType;
        List<? extends TypeMirror> typeArguments;
        if (this.isSubtypeOfDao(element.asType()) && (typeArguments = (declaredType = (DeclaredType)element.asType()).getTypeArguments()).size() == 2) {
            return typeArguments.get(index);
        }
        List<? extends TypeMirror> superTypes = this.helper.directSupertypes(element.asType());
        for (TypeMirror typeMirror : superTypes) {
            DeclaredType superDeclaredType;
            List<? extends TypeMirror> typeArguments2;
            if (typeMirror.getKind() != TypeKind.DECLARED || !this.isSubtypeOfDao(typeMirror) || (typeArguments2 = (superDeclaredType = (DeclaredType)typeMirror).getTypeArguments()).size() != 2) continue;
            return typeArguments2.get(index);
        }
        return null;
    }

    private boolean isSubtypeOfDao(TypeMirror type) {
        return this.helper.isSubtype(type, this.daoParametrizedType) || this.helper.isSubtype(type, this.runtimeExceptionDaoParametrizedType);
    }

    public DeclaredType getDaoParametrizedType() {
        if (this.daoParametrizedType == null) {
            this.createDaoParametrizedTypes();
        }
        return this.daoParametrizedType;
    }

    public DeclaredType getRuntimeExceptionDaoParametrizedType() {
        if (this.runtimeExceptionDaoParametrizedType == null) {
            this.createDaoParametrizedTypes();
        }
        return this.runtimeExceptionDaoParametrizedType;
    }

    public DeclaredType getTypedDao(Element element) {
        if (this.daoTypeElement == null) {
            this.createDaoParametrizedTypes();
        }
        return this.helper.getTypeUtils().getDeclaredType(this.daoTypeElement, this.getEntityType(element), this.getEntityIdType(element));
    }

    public DeclaredType getTypedRuntimeExceptionDao(Element element) {
        if (this.runtimeExceptionDaoTypeElement == null) {
            this.createDaoParametrizedTypes();
        }
        return this.helper.getTypeUtils().getDeclaredType(this.runtimeExceptionDaoTypeElement, this.getEntityType(element), this.getEntityIdType(element));
    }

    private void createDaoParametrizedTypes() {
        this.daoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.Dao");
        this.runtimeExceptionDaoTypeElement = this.helper.typeElementFromQualifiedName("com.j256.ormlite.dao.RuntimeExceptionDao");
        Types typeUtils = this.helper.getTypeUtils();
        WildcardType wildcardType = typeUtils.getWildcardType(null, null);
        this.daoParametrizedType = this.helper.getTypeUtils().getDeclaredType(this.daoTypeElement, wildcardType, wildcardType);
        this.runtimeExceptionDaoParametrizedType = this.helper.getTypeUtils().getDeclaredType(this.runtimeExceptionDaoTypeElement, wildcardType, wildcardType);
    }

    public static void injectReleaseInDestroy(JFieldVar databaseHelperRef, HasLifecycleMethods holder, ProcessHolder.Classes classes) {
        JBlock destroyBody = holder.getOnDestroyBeforeSuperBlock();
        destroyBody.staticInvoke(classes.OPEN_HELPER_MANAGER, "releaseHelper");
        destroyBody.assign(databaseHelperRef, JExpr._null());
    }
}

