/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JExpressionImpl;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.api.view.HasViews;
import org.androidannotations.api.view.OnViewChangedListener;
import org.androidannotations.api.view.OnViewChangedNotifier;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.ViewNotifierHelper;
import org.androidannotations.holder.EComponentHolder;
import org.androidannotations.holder.FoundHolder;
import org.androidannotations.holder.FoundViewHolder;
import org.androidannotations.holder.OnSeekBarChangeListenerHolder;
import org.androidannotations.holder.TextWatcherHolder;
import org.androidannotations.process.ProcessHolder;

public abstract class EComponentWithViewSupportHolder
extends EComponentHolder {
    protected APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    protected ViewNotifierHelper viewNotifierHelper;
    private JMethod onViewChanged;
    private JBlock onViewChangedBody;
    private JBlock onViewChangedBodyBeforeFindViews;
    private JVar onViewChangedHasViewsParam;
    protected Map<String, FoundHolder> foundHolders = new HashMap<String, FoundHolder>();
    protected JMethod findNativeFragmentById;
    protected JMethod findSupportFragmentById;
    protected JMethod findNativeFragmentByTag;
    protected JMethod findSupportFragmentByTag;
    private Map<String, TextWatcherHolder> textWatcherHolders = new HashMap<String, TextWatcherHolder>();
    private Map<String, OnSeekBarChangeListenerHolder> onSeekBarChangeListenerHolders = new HashMap<String, OnSeekBarChangeListenerHolder>();

    public EComponentWithViewSupportHolder(ProcessHolder processHolder, TypeElement annotatedElement) throws Exception {
        super(processHolder, annotatedElement);
        this.viewNotifierHelper = new ViewNotifierHelper(this);
    }

    public JBlock getOnViewChangedBody() {
        if (this.onViewChangedBody == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBody;
    }

    public JBlock getOnViewChangedBodyBeforeFindViews() {
        if (this.onViewChangedBodyBeforeFindViews == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedBodyBeforeFindViews;
    }

    public JVar getOnViewChangedHasViewsParam() {
        if (this.onViewChangedHasViewsParam == null) {
            this.setOnViewChanged();
        }
        return this.onViewChangedHasViewsParam;
    }

    protected void setOnViewChanged() {
        this.getGeneratedClass()._implements(OnViewChangedListener.class);
        this.onViewChanged = this.getGeneratedClass().method(1, this.codeModel().VOID, "onViewChanged");
        this.onViewChanged.annotate(Override.class);
        this.onViewChangedBody = this.onViewChanged.body();
        this.onViewChangedBodyBeforeFindViews = this.onViewChangedBody.block();
        this.onViewChangedHasViewsParam = this.onViewChanged.param(HasViews.class, "hasViews");
        JClass notifierClass = this.refClass(OnViewChangedNotifier.class);
        this.getInitBody().staticInvoke(notifierClass, "registerOnViewChangedListener").arg(JExpr._this());
    }

    public JInvocation findViewById(JFieldRef idRef) {
        JInvocation findViewById = JExpr.invoke((JExpression)this.getOnViewChangedHasViewsParam(), "findViewById");
        findViewById.arg(idRef);
        return findViewById;
    }

    public void assignFindViewById(JFieldRef idRef, JClass viewClass, JFieldRef fieldRef) {
        JExpression assignExpression;
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        FoundViewHolder foundViewHolder = (FoundViewHolder)this.foundHolders.get(idRefString);
        JBlock block = this.getOnViewChangedBody();
        if (foundViewHolder != null) {
            assignExpression = foundViewHolder.getOrCastRef(viewClass);
        } else {
            assignExpression = this.findViewById(idRef);
            if (viewClass != null && viewClass != this.classes().VIEW) {
                assignExpression = JExpr.cast(viewClass, assignExpression);
                if (viewClass.isParameterized()) {
                    this.codeModelHelper.addSuppressWarnings(this.onViewChanged, "unchecked");
                }
            }
            this.foundHolders.put(idRefString, new FoundViewHolder(this, viewClass, fieldRef, block));
        }
        block.assign(fieldRef, assignExpression);
    }

    public FoundViewHolder getFoundViewHolder(JFieldRef idRef, JClass viewClass) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        FoundViewHolder foundViewHolder = (FoundViewHolder)this.foundHolders.get(idRefString);
        if (foundViewHolder == null) {
            foundViewHolder = this.createFoundViewAndIfNotNullBlock(idRef, viewClass);
            this.foundHolders.put(idRefString, foundViewHolder);
        }
        return foundViewHolder;
    }

    protected FoundViewHolder createFoundViewAndIfNotNullBlock(JFieldRef idRef, JClass viewClass) {
        JExpressionImpl findViewExpression = this.findViewById(idRef);
        JBlock block = this.getOnViewChangedBody().block();
        if (viewClass == null) {
            viewClass = this.classes().VIEW;
        } else if (viewClass != this.classes().VIEW) {
            findViewExpression = JExpr.cast(viewClass, findViewExpression);
        }
        JVar view = block.decl(viewClass, "view", findViewExpression);
        return new FoundViewHolder(this, viewClass, view, block);
    }

    public JMethod getFindNativeFragmentById() {
        if (this.findNativeFragmentById == null) {
            this.setFindNativeFragmentById();
        }
        return this.findNativeFragmentById;
    }

    protected void setFindNativeFragmentById() {
        this.findNativeFragmentById = this.getGeneratedClass().method(4, this.classes().FRAGMENT, "findNativeFragmentById");
        JVar idParam = this.findNativeFragmentById.param(this.codeModel().INT, "id");
        JBlock body = this.findNativeFragmentById.body();
        body._if(this.getContextRef()._instanceof(this.classes().ACTIVITY).not())._then()._return(JExpr._null());
        JVar activityVar = body.decl(this.classes().ACTIVITY, "activity_", JExpr.cast(this.classes().ACTIVITY, this.getContextRef()));
        body._return(activityVar.invoke("getFragmentManager").invoke("findFragmentById").arg(idParam));
    }

    public JMethod getFindSupportFragmentById() {
        if (this.findSupportFragmentById == null) {
            this.setFindSupportFragmentById();
        }
        return this.findSupportFragmentById;
    }

    protected void setFindSupportFragmentById() {
        this.findSupportFragmentById = this.getGeneratedClass().method(4, this.classes().SUPPORT_V4_FRAGMENT, "findSupportFragmentById");
        JVar idParam = this.findSupportFragmentById.param(this.codeModel().INT, "id");
        JBlock body = this.findSupportFragmentById.body();
        body._if(this.getContextRef()._instanceof(this.classes().FRAGMENT_ACTIVITY).not())._then()._return(JExpr._null());
        JVar activityVar = body.decl(this.classes().FRAGMENT_ACTIVITY, "activity_", JExpr.cast(this.classes().FRAGMENT_ACTIVITY, this.getContextRef()));
        body._return(activityVar.invoke("getSupportFragmentManager").invoke("findFragmentById").arg(idParam));
    }

    public JMethod getFindNativeFragmentByTag() {
        if (this.findNativeFragmentByTag == null) {
            this.setFindNativeFragmentByTag();
        }
        return this.findNativeFragmentByTag;
    }

    protected void setFindNativeFragmentByTag() {
        this.findNativeFragmentByTag = this.getGeneratedClass().method(4, this.classes().FRAGMENT, "findNativeFragmentByTag");
        JVar tagParam = this.findNativeFragmentByTag.param(this.classes().STRING, "tag");
        JBlock body = this.findNativeFragmentByTag.body();
        body._if(this.getContextRef()._instanceof(this.classes().ACTIVITY).not())._then()._return(JExpr._null());
        JVar activityVar = body.decl(this.classes().ACTIVITY, "activity_", JExpr.cast(this.classes().ACTIVITY, this.getContextRef()));
        body._return(activityVar.invoke("getFragmentManager").invoke("findFragmentByTag").arg(tagParam));
    }

    public JMethod getFindSupportFragmentByTag() {
        if (this.findSupportFragmentByTag == null) {
            this.setFindSupportFragmentByTag();
        }
        return this.findSupportFragmentByTag;
    }

    protected void setFindSupportFragmentByTag() {
        this.findSupportFragmentByTag = this.getGeneratedClass().method(4, this.classes().SUPPORT_V4_FRAGMENT, "findSupportFragmentByTag");
        JVar tagParam = this.findSupportFragmentByTag.param(this.classes().STRING, "tag");
        JBlock body = this.findSupportFragmentByTag.body();
        body._if(this.getContextRef()._instanceof(this.classes().FRAGMENT_ACTIVITY).not())._then()._return(JExpr._null());
        JVar activityVar = body.decl(this.classes().FRAGMENT_ACTIVITY, "activity_", JExpr.cast(this.classes().FRAGMENT_ACTIVITY, this.getContextRef()));
        body._return(activityVar.invoke("getSupportFragmentManager").invoke("findFragmentByTag").arg(tagParam));
    }

    public TextWatcherHolder getTextWatcherHolder(JFieldRef idRef, TypeMirror viewParameterType) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        TextWatcherHolder textWatcherHolder = this.textWatcherHolders.get(idRefString);
        if (textWatcherHolder == null) {
            textWatcherHolder = this.createTextWatcherHolder(idRef, viewParameterType);
            this.textWatcherHolders.put(idRefString, textWatcherHolder);
        }
        return textWatcherHolder;
    }

    private TextWatcherHolder createTextWatcherHolder(JFieldRef idRef, TypeMirror viewParameterType) {
        JDefinedClass onTextChangeListenerClass = this.codeModel().anonymousClass(this.classes().TEXT_WATCHER);
        JClass viewClass = this.classes().TEXT_VIEW;
        if (viewParameterType != null) {
            viewClass = this.refClass(viewParameterType.toString());
        }
        JBlock onViewChangedBody = this.getOnViewChangedBody().block();
        JVar viewVariable = onViewChangedBody.decl(8, viewClass, "view", JExpr.cast(viewClass, this.findViewById(idRef)));
        onViewChangedBody._if(viewVariable.ne(JExpr._null()))._then().invoke((JExpression)viewVariable, "addTextChangedListener").arg(JExpr._new(onTextChangeListenerClass));
        return new TextWatcherHolder(this, viewVariable, onTextChangeListenerClass);
    }

    public OnSeekBarChangeListenerHolder getOnSeekBarChangeListenerHolder(JFieldRef idRef) {
        String idRefString = this.codeModelHelper.getIdStringFromIdFieldRef(idRef);
        OnSeekBarChangeListenerHolder onSeekBarChangeListenerHolder = this.onSeekBarChangeListenerHolders.get(idRefString);
        if (onSeekBarChangeListenerHolder == null) {
            onSeekBarChangeListenerHolder = this.createOnSeekBarChangeListenerHolder(idRef);
            this.onSeekBarChangeListenerHolders.put(idRefString, onSeekBarChangeListenerHolder);
        }
        return onSeekBarChangeListenerHolder;
    }

    private OnSeekBarChangeListenerHolder createOnSeekBarChangeListenerHolder(JFieldRef idRef) {
        JDefinedClass onSeekbarChangeListenerClass = this.codeModel().anonymousClass(this.classes().ON_SEEKBAR_CHANGE_LISTENER);
        JClass viewClass = this.classes().SEEKBAR;
        JBlock onViewChangedBody = this.getOnViewChangedBody().block();
        JVar viewVariable = onViewChangedBody.decl(8, viewClass, "view", JExpr.cast(viewClass, this.findViewById(idRef)));
        onViewChangedBody._if(viewVariable.ne(JExpr._null()))._then().invoke((JExpression)viewVariable, "setOnSeekBarChangeListener").arg(JExpr._new(onSeekbarChangeListenerClass));
        return new OnSeekBarChangeListenerHolder(this, onSeekbarChangeListenerClass);
    }
}

