/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.holder;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JVar;
import org.androidannotations.holder.EComponentWithViewSupportHolder;
import org.androidannotations.holder.GeneratedClassHolderDecorator;

public class TextWatcherHolder
extends GeneratedClassHolderDecorator<EComponentWithViewSupportHolder> {
    private JVar textViewVariable;
    private JDefinedClass listenerClass;
    private JBlock beforeTextChangedBody;
    private JVar beforeTextChangedCharSequenceParam;
    private JVar beforeTextChangedStartParam;
    private JVar beforeTextChangedCountParam;
    private JVar beforeTextChangedAfterParam;
    private JBlock onTextChangedBody;
    private JVar onTextChangedCharSequenceParam;
    private JVar onTextChangedStartParam;
    private JVar onTextChangedBeforeParam;
    private JVar onTextChangedCountParam;
    private JBlock afterTextChangedBody;
    private JVar afterTextChangedEditableParam;

    public TextWatcherHolder(EComponentWithViewSupportHolder holder, JVar viewVariable, JDefinedClass onTextChangeListenerClass) {
        super(holder);
        this.textViewVariable = viewVariable;
        this.listenerClass = onTextChangeListenerClass;
        this.createBeforeTextChanged();
        this.createOnTextChanged();
        this.createAfterTextChanged();
    }

    private void createBeforeTextChanged() {
        JPrimitiveType intClass = ((EComponentWithViewSupportHolder)this.holder).codeModel().INT;
        JMethod beforeTextChangedMethod = this.listenerClass.method(1, ((EComponentWithViewSupportHolder)this.holder).codeModel().VOID, "beforeTextChanged");
        beforeTextChangedMethod.annotate(Override.class);
        this.beforeTextChangedBody = beforeTextChangedMethod.body();
        this.beforeTextChangedCharSequenceParam = beforeTextChangedMethod.param(((EComponentWithViewSupportHolder)this.holder).classes().CHAR_SEQUENCE, "s");
        this.beforeTextChangedStartParam = beforeTextChangedMethod.param(intClass, "start");
        this.beforeTextChangedCountParam = beforeTextChangedMethod.param(intClass, "count");
        this.beforeTextChangedAfterParam = beforeTextChangedMethod.param(intClass, "after");
    }

    private void createOnTextChanged() {
        JPrimitiveType intClass = ((EComponentWithViewSupportHolder)this.holder).codeModel().INT;
        JMethod onTextChangedMethod = this.listenerClass.method(1, ((EComponentWithViewSupportHolder)this.holder).codeModel().VOID, "onTextChanged");
        onTextChangedMethod.annotate(Override.class);
        this.onTextChangedBody = onTextChangedMethod.body();
        this.onTextChangedCharSequenceParam = onTextChangedMethod.param(((EComponentWithViewSupportHolder)this.holder).classes().CHAR_SEQUENCE, "s");
        this.onTextChangedStartParam = onTextChangedMethod.param(intClass, "start");
        this.onTextChangedBeforeParam = onTextChangedMethod.param(intClass, "before");
        this.onTextChangedCountParam = onTextChangedMethod.param(intClass, "count");
    }

    private void createAfterTextChanged() {
        JMethod afterTextChangedMethod = this.listenerClass.method(1, ((EComponentWithViewSupportHolder)this.holder).codeModel().VOID, "afterTextChanged");
        afterTextChangedMethod.annotate(Override.class);
        this.afterTextChangedBody = afterTextChangedMethod.body();
        this.afterTextChangedEditableParam = afterTextChangedMethod.param(((EComponentWithViewSupportHolder)this.holder).classes().EDITABLE, "s");
    }

    public JVar getTextViewVariable() {
        return this.textViewVariable;
    }

    public JBlock getBeforeTextChangedBody() {
        return this.beforeTextChangedBody;
    }

    public JVar getBeforeTextChangedCharSequenceParam() {
        return this.beforeTextChangedCharSequenceParam;
    }

    public JVar getBeforeTextChangedStartParam() {
        return this.beforeTextChangedStartParam;
    }

    public JVar getBeforeTextChangedCountParam() {
        return this.beforeTextChangedCountParam;
    }

    public JVar getBeforeTextChangedAfterParam() {
        return this.beforeTextChangedAfterParam;
    }

    public JBlock getOnTextChangedBody() {
        return this.onTextChangedBody;
    }

    public JVar getOnTextChangedCharSequenceParam() {
        return this.onTextChangedCharSequenceParam;
    }

    public JVar getOnTextChangedStartParam() {
        return this.onTextChangedStartParam;
    }

    public JVar getOnTextChangedBeforeParam() {
        return this.onTextChangedBeforeParam;
    }

    public JVar getOnTextChangedCountParam() {
        return this.onTextChangedCountParam;
    }

    public JBlock getAfterTextChangedBody() {
        return this.afterTextChangedBody;
    }

    public JVar getAfterTextChangedEditableParam() {
        return this.afterTextChangedEditableParam;
    }
}

