/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.process;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import org.androidannotations.exception.ProcessingException;
import org.androidannotations.handler.AnnotationHandler;
import org.androidannotations.handler.AnnotationHandlers;
import org.androidannotations.holder.GeneratedClassHolder;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.model.AnnotationElementsHolder;

public class ModelValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelValidator.class);
    private AnnotationHandlers annotationHandlers;

    public ModelValidator(AnnotationHandlers annotationHandlers) {
        this.annotationHandlers = annotationHandlers;
    }

    public AnnotationElements validate(AnnotationElementsHolder extractedModel) throws ProcessingException, Exception {
        LOGGER.info("Validating elements", new Object[0]);
        AnnotationElementsHolder validatedElements = extractedModel.validatingHolder();
        for (AnnotationHandler<? extends GeneratedClassHolder> annotationHandler : this.annotationHandlers.get()) {
            String validatorSimpleName = annotationHandler.getClass().getSimpleName();
            String annotationName = annotationHandler.getTarget();
            Set<? extends Element> annotatedElements = extractedModel.getRootAnnotatedElements(annotationName);
            HashSet<Element> validatedAnnotatedElements = new HashSet<Element>();
            validatedElements.putRootAnnotatedElements(annotationName, validatedAnnotatedElements);
            if (!annotatedElements.isEmpty()) {
                LOGGER.debug("Validating with {}: {}", validatorSimpleName, annotatedElements);
            }
            for (Element element : annotatedElements) {
                if (this.validateThrowing(annotationHandler, element, validatedElements)) {
                    validatedAnnotatedElements.add(element);
                    continue;
                }
                LOGGER.warn("Element {} unvalidated by {}", element, validatorSimpleName);
            }
        }
        return validatedElements;
    }

    private boolean validateThrowing(AnnotationHandler<?> handler, Element element, AnnotationElements validatedElements) throws Exception, ProcessingException {
        try {
            return handler.validate(element, validatedElements);
        }
        catch (Exception e) {
            throw new ProcessingException(e, element);
        }
    }
}

