/*
 * Decompiled with CFR 0.152.
 */
package com.harukizaemon.simian;

import com.harukizaemon.simian.Y;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class Option
implements Comparable {
    private static final Map C = new HashMap();
    static final String D = "=";
    public static final Option LANGUAGE = new Option("language", "=LANG", "Assumes ALL files are in the specified language");
    public static final Option DEFAULT_LANGUAGE = new Option("defaultLanguage", "=LANG", "Assumes files are in the specified language if none can be inferred");
    public static final Option THRESHOLD = new Option("threshold", "=COUNT", "Matches will contain at least the specified number of lines");
    public static final Option FAIL_ON_DUPLICATION = new Option("failOnDuplication", "[+|-|%]", "Exits with a failure return code if duplication detected");
    public static final Option BALANCE_CURLY_BRACES = new Option("balanceCurlyBraces", "[+|-]", "Accounts for curly braces when breaking lines");
    public static final Option BALANCE_PARENTHESES = new Option("balanceParentheses", "[+|-]", "Accounts for parentheses when breaking lines");
    public static final Option BALANCE_SQUARE_BRACKETS = new Option("balanceSquareBrackets", "[+|-]", "Accounts for square brackets when breaking lines");
    public static final Option IGNORE_CURLY_BRACES = new Option("ignoreCurlyBraces", "[+|-]", "Completely ignores curly braces");
    public static final Option IGNORE_MODIFIERS = new Option("ignoreModifiers", "[+|-]", "Ignores modifiers (public, private, static, etc.)");
    public static final Option IGNORE_NUMBERS = new Option("ignoreNumbers", "[+|-]", "Completely ignores numbers");
    public static final Option IGNORE_STRINGS = new Option("ignoreStrings", "[+|-]", "Completely ignores the contents of strings");
    public static final Option IGNORE_STRING_CASE = new Option("ignoreStringCase", "[+|-]", "Matches string literals irrespective of case");
    public static final Option IGNORE_CHARACTER_CASE = new Option("ignoreCharacterCase", "[+|-]", "Matches character literals irrespective of case");
    public static final Option IGNORE_SUBTYPE_NAMES = new Option("ignoreSubtypeNames", "[+|-]", "Matches on similar type names (eg. Reader and FilterReader)");
    public static final Option IGNORE_CHARACTERS = new Option("ignoreCharacters", "[+|-]", "Completely ignores character literals");
    public static final Option IGNORE_LITERALS = new Option("ignoreLiterals", "[+|-]", "Completely ignores all literals (strings, numbers and characters)");
    public static final Option IGNORE_REGIONS = new Option("ignoreRegions", "[+|-]", "Ignores all lines between #region/#endregion");
    public static final Option IGNORE_IDENTIFIER_CASE = new Option("ignoreIdentifierCase", "[+|-]", "Matches identifiers irresepctive of case");
    public static final Option IGNORE_VARIABLE_NAMES = new Option("ignoreVariableNames", "[+|-]", "Completely ignores variable names (fields, parameters and locals)");
    public static final Option IGNORE_IDENTIFIERS = new Option("ignoreIdentifiers", "[+|-]", "Completely ignores identifiers");
    public static final Option IGNORE_BLOCKS = new Option("ignoreBlocks", "=START:END", "Ignores all lines between START/END", true);
    public static final Option REPORT_DUPLICATE_TEXT = new Option("reportDuplicateText", "[+|-]", "Prints the duplicate text in reports");
    public static final Option IGNORE_OVERLAPPING_BLOCKS = new Option("ignoreOverlappingBlocks", "[+|-]", "Ignores blocks that wholly or partially overlap");
    private final String F;
    private final String B;
    private final String A;
    private final boolean E;

    public Option(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public Option(String string, String string2, String string3, boolean bl) {
        Y.A(string, "name");
        Y.A(string2, "parameters");
        Y.A(string3, "description");
        this.F = string;
        this.B = string2;
        this.A = string3;
        this.E = bl;
        C.put(string, this);
    }

    public String getName() {
        return this.F;
    }

    public String getParameters() {
        return this.B;
    }

    public String getDescription() {
        return this.A;
    }

    public int compareTo(Object object) {
        return this.compareTo((Option)object);
    }

    public int compareTo(Option option) {
        Y.A(option, "other");
        return this.F.compareTo(option.F);
    }

    public static SortedSet getValidOptions() {
        return new TreeSet(C.values());
    }

    public static boolean isValidOption(String string) {
        return C.containsKey(string);
    }

    public boolean isMultiValued() {
        return this.E;
    }

    public static Option valueOf(Object object) {
        Option option = (Option)C.get(object);
        Y.A(option != null, "invalid name");
        return option;
    }

    public String toString() {
        return this.F;
    }
}

