﻿![This is ChroMapper.](https://i.imgur.com/nQ7caC2.png)

[![Crowdin](https://badges.crowdin.net/chromapper/localized.svg)](https://crowdin.com/project/chromapper)

# This is ChroMapper.
ChroMapper is a Unity-based map editor for Beat Saber, specializing in modded map creation. ChroMapper also offers various tools and features that tailor towards the advanced mappers of the community.

## Features
- **360/90 Support** for the first time ever in a community map editor.
- **Chroma 2.0 Lighting** brings lightshows to the next level.
- **Optimized** to run on a wide range of devices, from high-end VR machines to [Chromebooks](https://cdn.discordapp.com/attachments/702231982335197264/892184054147993640/20210927_190030.jpg).
- **Cross-platform**, with official x64 builds available for Windows, Mac OS, and Linux. Individual users may also build ChroMapper for other platforms.
- **Rebindable Keys** means you can adapt your mapping workflow to whatever input device you have installed.

### Get Started
Check out the [ChroMapper Wiki](https://chromapper.atlassian.net/wiki/spaces/UG/overview) for some basic documentation about the program, setting it up, and its features.

For new users, you might also find the [ChroMapper Tutorial by Atlas Rhythm](https://youtu.be/6SixwKR43Zg) useful.

# Releases

## ChroMapper Launcher (Recommended)
The recommended method of installing ChroMapper is through the [ChroMapper Launcher](https://cm.topc.at/dl). Not only does this download the necessary files to run ChroMapper, but it also serves as an auto updater, so you never go out of date.

## Jenkins CI
Builds are automatically created with [Jenkins](https://jenkins.kirkstall.top-cat.me/view/All/job/ChroMapper/). Jenkins also pushes updates for the ChroMapper Launcher. If you need to download a specific version of ChroMapper, you can find them here.

## GitHub Releases
GitHub Releases will be made with every stable update. While builds will be distributed, it is recommended to use the ChroMapper Launcher to automatically stay up to date.

# Discord
The ChroMapper Disccord is the central point of communication between users and the developers. It is recommended to visit the Discord to recieve support, talk about development, and share your work.

Join the Discord [here](https://discord.gg/YmEt9EZ8pw).

# Patreon
If you'd like to donate to the project and get some sweet perks, you can [support ChroMapper development on Patreon](https://www.patreon.com/Caeden117).

# Localization
If you want to help translate this application into other languages, you can head over to [CrowdIn](https://crwd.in/chromapper). Updated localization from CrowdIn is pulled into ChroMapper on a semi-occasional basis.

# For Developers
ChroMapper is developed with Unity in C#. Please see the [build guide](BUILD.md) for setting up your development environment.

## License
The project uses the [GNU GPL v2 license](https://github.com/Caeden117/ChroMapper/blob/master/LICENSE). Please keep that license in mind as you make contributions to ChroMapper.
