Report
======
This document describes the Puppet master's report endpoint and the schema for
Report Format 4 in technical term. Also see the
[documentation](https://docs.puppetlabs.com/puppet/latest/reference/format_report.html).

The `report` endpoint allows clients to send reports to the master via `http`
or `https`.  Once received by the master they are processed by the *report
processors* configured to be triggered when a report is received. As an
example, storing reports in PuppetDB is handled by one such report processor.

Save
----
The http(s) endpoint for sending reports to the master is:

    PUT /puppet/v3/report/:nodename?environment=:environment

### Supported HTTP Methods

PUT

### Supported Format(s)

PSON

### Parameters

None

### Content

The content of a report is typically generated by the Puppet Runtime and consists of a pson-serialization of `Puppet::Transaction::Report` object which in turn contains a structure of objects with of the following runtime types:

* `Puppet::Util::Log`
* `Puppet::Util::Metric`
* `Puppet::Resource::Status`
* `Puppet::Transaction::Event`

This pson-serialization is compliant with the endpoint's report jsonschema.

Example
-------
Here is an example of a PUT request. (Note that the content-length is not correct as the
example is formatted for readability)

    PUT /puppet/v3/report/kermit.com?environment=production HTTP/1.0
    ContentType: text/pson
    Content-Length: 1428

    {"host"=>"kermit.com",
     "time"=>"2013-09-12T03:50:59.009301000+02:00",
     "configuration_version"=>1357986,
     "transaction_uuid"=>"df34516e-4050-402d-a166-05b03b940749",
     "code_id"=>null,
     "catalog_uuid"=>"827a74c8-cf98-44da-9ff7-18c5e4bee41e",
     "catalog_format"=>1,
     "report_format"=>5,
     "puppet_version"=>"3.3.0",
     "kind"=>"apply",
     "status"=>"unchanged",
     "environment"=>"test_environment",
     "logs"=>
      [{"level"=>"warning",
        "message"=>"log message",
        "source"=>"Puppet",
        "tags"=>["warning"],
        "time"=>"2013-09-12T03:50:59.009328000+02:00",
        "file"=>nil,
        "line"=>nil}],
     "metrics"=>
      {"resources"=>
        {"name"=>"resources",
         "label"=>"Resources",
         "values"=>
          [["total", "Total", 1],
           ["skipped", "Skipped", 0],
           ["failed", "Failed", 0],
           ["failed_to_restart", "Failed to restart", 0],
           ["restarted", "Restarted", 0],
           ["changed", "Changed", 1],
           ["out_of_sync", "Out of sync", 0],
           ["scheduled", "Scheduled", 0]]},
       "time"=>
        {"name"=>"time",
         "label"=>"Time",
         "values"=>[["timing", "Timing", 4], ["total", "Total", 4]]},
       "changes"=>
        {"name"=>"changes", "label"=>"Changes", "values"=>[["total", "Total", 0]]},
       "events"=>
        {"name"=>"events",
         "label"=>"Events",
         "values"=>
          [["total", "Total", 0],
           ["failure", "Failure", 0],
           ["success", "Success", 0]]}},
     "resource_statuses"=>
      {"Notify[a resource]"=>
        {"title"=>"a resource",
         "file"=>nil,
         "line"=>nil,
         "resource"=>"Notify[a resource]",
         "resource_type"=>"Notify",
         "containment_path"=>["Notify[a resource]"],
         "evaluation_time"=>nil,
         "tags"=>["notify"],
         "time"=>"2013-09-12T03:50:59.009238000+02:00",
         "failed"=>false,
         "changed"=>true,
         "out_of_sync"=>false,
         "skipped"=>false,
         "change_count"=>0,
         "out_of_sync_count"=>0,
         "events"=>[]}},
      "cached_catalog_status"=> "not_used"}

Schema
------

The sent report objects must conform to
[the report schema.](../schemas/report.json)
