//
// Autogen RepeatInfoTest.auto.cs
//
// Author:
//	Ben Maurer <bmaurer@novell.com>
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System;
using System.IO;


class X {
	//
	// KEEP THIS IN SYNC WITH THE ONE IN QUOTES!
	//
	public class RepeatInfoUser : IRepeatInfoUser {

		private bool footer;
		private bool header;
		private bool separators;
		private int count;
		private int counter;


		public RepeatInfoUser (bool header, bool footer, bool separators, int count)
		{
			this.footer = footer;
			this.header = header;
			this.separators = separators;
			this.count = count;
		}

		static HtmlTextWriter GetWriter ()
		{
			StringWriter sw = new StringWriter ();
			sw.NewLine = "\n";
			return new HtmlTextWriter (sw);
		}

		public static string DoTest (int cols, int cnt, RepeatDirection d, RepeatLayout l, bool OuterTableImplied, bool hdr, bool ftr, bool sep)
		{
			HtmlTextWriter htw = GetWriter ();
			RepeatInfo ri = new RepeatInfo ();
			ri.RepeatColumns = cols;
			ri.RepeatDirection = d;
			ri.RepeatLayout = l;
			ri.OuterTableImplied = OuterTableImplied;
			// get some variation in if we use style or not
			Style s = new Style ();
			if (cols != 3)
				s.CssClass = "mainstyle";
			
			ri.RenderRepeater (htw, new RepeatInfoUser (hdr, ftr, sep, cnt), s, new DataList ());
			return htw.InnerWriter.ToString ();
		}


		public bool HasFooter {
			get { return footer; }
		}

		public bool HasHeader {
			get { return header; }
		}
		
		public bool HasSeparators {
			get { return separators; }
		}

		public int RepeatedItemCount {
			get { return count; }
		}

		public Style GetItemStyle (ListItemType itemType, int repeatIndex)
		{
			Style s = new Style ();
			s.CssClass = String.Format ("{0}{1}", itemType, repeatIndex);
			return s;
		}

		public void RenderItem (ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer)
		{
			writer.Write ("({0},{1},{2})", counter++, itemType, repeatIndex);
		}
	}

	static void Main ()
	{
#if NET_2_0
	  Console.WriteLine ("#if NET_2_0");
#else
	  Console.WriteLine ("#if !NET_2_0");
#endif

		Console.WriteLine (@"
// THIS IS AUTOGENERATED DO NOT EDIT
//
// Authors:
//    Ben Maurer (bmaurer@novell.com)
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// ""Software""), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED ""AS IS"", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using NUnit.Framework;
namespace MonoTests.System.Web.UI.WebControls {
[TestFixture]
public class RepeatInfo_Autogen {
	public class RepeatInfoUser : IRepeatInfoUser {

		private bool footer;
		private bool header;
		private bool separators;
		private int count;
		private int counter;


		public RepeatInfoUser (bool header, bool footer, bool separators, int count)
		{
			this.footer = footer;
			this.header = header;
			this.separators = separators;
			this.count = count;
		}

		static HtmlTextWriter GetWriter ()
		{
			StringWriter sw = new StringWriter ();
			sw.NewLine = ""\n"";
			return new HtmlTextWriter (sw);
		}

		public static string DoTest (int cols, int cnt, RepeatDirection d, RepeatLayout l, bool OuterTableImplied, bool hdr, bool ftr, bool sep)
		{
			HtmlTextWriter htw = GetWriter ();
			RepeatInfo ri = new RepeatInfo ();
			ri.RepeatColumns = cols;
			ri.RepeatDirection = d;
			ri.RepeatLayout = l;
			ri.OuterTableImplied = OuterTableImplied;
			Style s = new Style ();
			if (cols != 3)
				s.CssClass = ""mainstyle"";

			ri.RenderRepeater (htw, new RepeatInfoUser (hdr, ftr, sep, cnt), s, new DataList ());
			return htw.InnerWriter.ToString ();
		}


		public bool HasFooter {
			get { return footer; }
		}

		public bool HasHeader {
			get { return header; }
		}
		
		public bool HasSeparators {
			get { return separators; }
		}

		public int RepeatedItemCount {
			get { return count; }
		}

		public Style GetItemStyle (ListItemType itemType, int repeatIndex)
		{
			Style s = new Style ();
			s.CssClass = String.Format (""{0}{1}"", itemType, repeatIndex);
			return s;
		}

		public void RenderItem (ListItemType itemType, int repeatIndex, RepeatInfo repeatInfo, HtmlTextWriter writer)
		{
			writer.Write (""({0},{1},{2})"", counter++, itemType, repeatIndex);
		}
	}");
		
		
		int num = 0;
		int [][] combos = {
			new int [] {0, 0},
			new int [] {0, 1},
			new int [] {0, 2},
			new int [] {0, 5},
			new int [] {1, 0},
			new int [] {1, 5},
			new int [] {2, 4},
			new int [] {2, 7},
			new int [] {3, 9},
			new int [] {3, 7}
		};
		
		
		for (int i = 0; i < (1 << 6); i ++) {
			RepeatDirection d = (RepeatDirection) (i & (1 << 0));
			RepeatLayout l    = (RepeatLayout)    ((i & (1 << 1)) >> 1);
			bool oti          =                   (i & (1 << 2)) == 0;
			bool hdr          =                   (i & (1 << 3)) == 0;
			bool ftr          =                   (i & (1 << 4)) == 0;
			bool sep          =                   (i & (1 << 5)) == 0;

			foreach (int [] col_cnt in combos) {
				string nm = String.Format ("RepeatInfo_{0}cols_{1}itms_{2}_{3}{4}{5}{6}{7}",
						col_cnt [0],
						col_cnt [1],
						d == RepeatDirection.Vertical ? "vert" : "horiz",
						l == RepeatLayout.Flow ? "flow" : "tbl",
						oti ? "_otrtblimp" : "",
						hdr ? "_hdr" : "",
						ftr ? "_ftr" : "",
						sep ? "_sep" : "");
				Console.WriteLine (@"
	[Test]
	public void {0} ()
	{{
 		// cols              : {1}
		// cnt               : {2}
		// RepeatDirection   : {3}
		// RepeatLayout      : {4}
		// OuterTableImplied : {5}
		// Header            : {6}
		// Footer            : {7}
		// Separator         : {8}
",
						nm,
						col_cnt [0],
						col_cnt [1],
						d,
						l,
						oti,
						hdr,
						ftr,
						sep
					);
				string exp = RepeatInfoUser.DoTest (col_cnt [0], col_cnt [1], d, l, oti, hdr, ftr, sep).Replace (@"""", @"""""");
				Console.WriteLine (@"
		string v = RepeatInfoUser.DoTest ({0}, {1}, RepeatDirection.{2}, RepeatLayout.{3}, {4}, {5}, {6}, {7});
		string exp = @""{8}"";
		Assert.AreEqual (exp, v, ""#{9}"");
	}}
",
						
						col_cnt [0],
						col_cnt [1],
						d,
						l,
						oti ? "true" : "false",
						hdr ? "true" : "false",
						ftr ? "true" : "false",
						sep ? "true" : "false",
						exp,
						num ++
					);
			}
		}
		Console.WriteLine (@"
}
}
#endif");
	}
}
