/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;

@BugPattern(name="MisusedWeekYear", summary="Use of \"YYYY\" (week year) in a date pattern without \"ww\" (week in year). You probably meant to use \"yyyy\" (year) instead.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class MisusedWeekYear
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher {
    private static final String JAVA_SIMPLE_DATE_FORMAT = "java.text.SimpleDateFormat";
    private static final String ICU_SIMPLE_DATE_FORMAT = "com.ibm.icu.text.SimpleDateFormat";
    private static final Matcher<NewClassTree> simpleDateFormatConstructorMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String"}), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.text.DateFormatSymbols"}), Matchers.constructor().forClass("java.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.text.DateFormatSymbols"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.text.DateFormatSymbols", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.util.Locale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "java.lang.String", "com.ibm.icu.util.ULocale"}), Matchers.constructor().forClass("com.ibm.icu.text.SimpleDateFormat").withParameters(new String[]{"java.lang.String", "com.ibm.icu.util.ULocale"})});
    private static final Matcher<ExpressionTree> applyPatternMatcher = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("java.text.SimpleDateFormat").named("applyLocalizedPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyPattern"), Matchers.instanceMethod().onExactClass("com.ibm.icu.text.SimpleDateFormat").named("applyLocalizedPattern")});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!applyPatternMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0));
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!simpleDateFormatConstructorMatcher.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.constructDescription(tree, tree.getArguments().get(0));
    }

    private Description constructDescription(Tree tree, ExpressionTree patternArg) {
        String pattern = (String)ASTHelpers.constValue((Tree)((JCTree)((Object)patternArg)));
        if (pattern != null && pattern.contains("YYYY") && !pattern.contains("ww")) {
            if (patternArg.getKind() == Tree.Kind.STRING_LITERAL) {
                String replacement = patternArg.toString().replace("YYYY", "yyyy");
                return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)patternArg, (String)replacement));
            }
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

