/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.android;

import com.google.common.base.Preconditions;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.ElementKind;

@BugPattern(name="RestrictTo", summary="Use of method or class annotated with @RestrictTo", category=BugPattern.Category.ANDROID, severity=BugPattern.SeverityLevel.ERROR)
public final class RestrictToEnforcer
extends BugChecker
implements BugChecker.AnnotationTreeMatcher,
BugChecker.LambdaExpressionTreeMatcher,
BugChecker.MemberReferenceTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.MethodTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.IdentifierTreeMatcher {
    public final Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (!RestrictToEnforcer.compilingSupportLibrary(state) && symbol.flatName().contentEquals("android.support.annotation.RestrictTo")) {
            return this.buildDescription(tree).setMessage("@RestrictTo cannot be used outside the support library").build();
        }
        return Description.NO_MATCH;
    }

    public final Description matchIdentifier(IdentifierTree tree, VisitorState state) {
        Symbol.TypeSymbol typeSymbol;
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Symbol symbol = ASTHelpers.getSymbol((Tree)tree);
        if (symbol instanceof Symbol.TypeSymbol && RestrictToEnforcer.checkEnclosingClasses(typeSymbol = (Symbol.TypeSymbol)symbol, state)) {
            return this.describe((Tree)tree, symbol.enclClass(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Type lambdaType = ASTHelpers.getUpperBound((Type)ASTHelpers.getType((Tree)tree), (Types)state.getTypes());
        if (RestrictToEnforcer.checkEnclosingTypes(lambdaType, state)) {
            return this.describe((Tree)tree, lambdaType.asElement().enclClass(), state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        return this.matchInvokedMethod(tree, method, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((NewClassTree)tree);
        return this.matchInvokedMethod(tree, method, state);
    }

    public Description matchMemberReference(MemberReferenceTree tree, VisitorState state) {
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Type refType = ASTHelpers.getUpperBound((Type)ASTHelpers.getResultType((ExpressionTree)tree), (Types)state.getTypes());
        if (RestrictToEnforcer.checkEnclosingTypes(refType, state)) {
            return this.describe((Tree)tree, refType.asElement().enclClass(), state);
        }
        Symbol.MethodSymbol symbol = ASTHelpers.getSymbol((MemberReferenceTree)tree);
        if (!(symbol instanceof Symbol.MethodSymbol)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = symbol;
        return this.matchInvokedMethod(tree, method, state);
    }

    private Description matchInvokedMethod(ExpressionTree tree, Symbol.MethodSymbol method, VisitorState state) {
        if (RestrictToEnforcer.methodIsRestricted(method, state)) {
            return this.describe((Tree)tree, method, state);
        }
        if (method.getKind() == ElementKind.CONSTRUCTOR) {
            if (RestrictToEnforcer.checkEnclosingClasses(method, state)) {
                return this.describe((Tree)tree, method, state);
            }
        } else {
            Type receiverType = ASTHelpers.getUpperBound((Type)ASTHelpers.getReceiverType((ExpressionTree)tree), (Types)state.getTypes());
            if (RestrictToEnforcer.checkEnclosingTypes(receiverType, state)) {
                return this.describe(tree, receiverType.asElement().enclClass(), method, state);
            }
        }
        return this.matchMethodSymbol(tree, method, state);
    }

    private Description matchMethodSymbol(Tree tree, Symbol.MethodSymbol method, VisitorState state) {
        for (Symbol.MethodSymbol superSymbol : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
            if (!RestrictToEnforcer.methodIsRestricted(superSymbol, state)) continue;
            return this.describe(tree, superSymbol, state);
        }
        return Description.NO_MATCH;
    }

    public Description matchMethod(MethodTree tree, VisitorState state) {
        if (RestrictToEnforcer.compilingSupportLibrary(state)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)tree);
        if (RestrictToEnforcer.checkEnclosingClasses(method, state)) {
            return this.describe((Tree)tree, method, state);
        }
        for (Type type : state.getTypes().closure((Type)ASTHelpers.enclosingClass((Symbol)method).asType())) {
            Symbol.MethodSymbol superSymbol = ASTHelpers.findSuperMethodInType((Symbol.MethodSymbol)method, (Type)type, (Types)state.getTypes());
            if (superSymbol == null || !RestrictToEnforcer.methodIsRestricted(superSymbol, state)) continue;
            return this.describe((Tree)tree, superSymbol, state);
        }
        return Description.NO_MATCH;
    }

    private Description describe(Tree tree, Symbol.MethodSymbol method, VisitorState state) {
        return this.describe(tree, ASTHelpers.enclosingClass((Symbol)method), method, state);
    }

    private Description describe(Tree tree, Symbol.ClassSymbol classSym, Symbol.MethodSymbol method, VisitorState state) {
        return this.describe(tree, String.format("Method %s.%s is restricted, not for use outside the support library.", classSym, Signatures.prettyMethodSignature((Symbol.ClassSymbol)ASTHelpers.enclosingClass((Symbol)method), (Symbol.MethodSymbol)method)), state);
    }

    private Description describe(Tree tree, String message, VisitorState state) {
        return this.buildDescription(tree).setMessage(message).build();
    }

    private Description describe(Tree tree, Symbol.ClassSymbol classSym, VisitorState state) {
        return this.describe(tree, String.format("Class %s is restricted, not for use outside the support library.", classSym), state);
    }

    private static boolean methodIsRestricted(Symbol.MethodSymbol method, VisitorState state) {
        return RestrictToEnforcer.symbolInSupportLibrary(method) && RestrictToEnforcer.hasRestrictedAnnotation(method, state);
    }

    private static boolean symbolInSupportLibrary(Symbol sym) {
        return ASTHelpers.enclosingPackage((Symbol)sym).getQualifiedName().toString().startsWith("android.support");
    }

    private static boolean compilingSupportLibrary(VisitorState state) {
        ExpressionTree tree = state.getPath().getCompilationUnit().getPackageName();
        return tree != null && (tree.toString().startsWith("android.support") || tree.toString().startsWith("android.arch"));
    }

    private static boolean checkEnclosingTypes(Type type, VisitorState state) {
        Symbol.ClassSymbol clazz = type.asElement().enclClass();
        Preconditions.checkNotNull((Object)clazz, (String)"Type %s has no enclosing class", (Object)type);
        return RestrictToEnforcer.checkEnclosingClasses(clazz, state);
    }

    private static boolean checkEnclosingClasses(Symbol symbol, VisitorState state) {
        if (!RestrictToEnforcer.symbolInSupportLibrary(symbol)) {
            return false;
        }
        Symbol enclosingClass = symbol;
        while (enclosingClass != null) {
            if (RestrictToEnforcer.hasRestrictedAnnotation(enclosingClass, state)) {
                return true;
            }
            enclosingClass = enclosingClass.owner.enclClass();
        }
        return false;
    }

    private static boolean hasRestrictedAnnotation(Symbol sym, VisitorState state) {
        return ASTHelpers.hasAnnotation((Symbol)sym, (String)"android.support.annotation.RestrictTo", (VisitorState)state);
    }
}

