---
title: "Compiler Error CS0266 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0266"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0266"
ms.assetid: 6cca5d6a-f3e0-482a-af25-af73bfe3e303
caps.latest.revision: 11
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0266
Cannot implicitly convert type 'type1' to 'type2'. An explicit conversion exists (are you missing a cast?)  
  
 This error occurs when your code tries to convert between two types that cannot be implicitly converted, but where an explicit conversion is available. For more information, see [Casting and Type Conversions](../../../csharp/programming-guide/types/casting-and-type-conversions.md).  
  
 The following code shows examples that generate CS0266.  
  
```cs  
// CS0266.cs  
class MyClass  
{  
    public static void Main()  
    {  
        // You cannot implicitly convert a double to an integer.  
        double d = 3.2;  
  
        // The following line causes compiler error CS0266.  
        int i1 = d;  
  
        // However, you can resolve the error by using an explicit conversion.  
        int i2 = (int)d;  
  
        // You cannot implicitly convert an object to a class type.  
        object obj = "MyString";  
  
        // The following assignment statement causes error CS0266.  
        MyClass myClass = obj;    
  
        // You can resolve the error by using an explicit conversion.  
        MyClass c = ( MyClass )obj;  
  
        // You cannot implicitly convert a base class object to a derived class type.  
        MyClass mc = new MyClass();  
        DerivedClass dc = new DerivedClass();  
  
        // The following line causes compiler error CS0266.  
        dc = mc;  
  
        // You can resolve the error by using an explicit conversion.  
        dc = (DerivedClass)mc;  
    }  
}  
  
class DerivedClass : MyClass  
{  
}  
  
```