---
title: "Modifiers (C# Reference) | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "article"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "keywords [C#], modifiers"
  - "modifiers [C#]"
ms.assetid: c96691dd-b357-49ec-b5ae-03ca214fadfb
caps.latest.revision: 18
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Modifiers (C# Reference)
Modifiers are used to modify declarations of types and type members. This section introduces the C# modifiers.  
  
|Modifier|Purpose|  
|--------------|-------------|  
|[Access Modifiers](../../../csharp/language-reference/keywords/access-modifiers.md)<br /><br /> -   [public](../../../csharp/language-reference/keywords/public.md)<br />-   [private](../../../csharp/language-reference/keywords/private.md)<br />-   [internal](../../../csharp/language-reference/keywords/internal.md)<br />-   [protected](../../../csharp/language-reference/keywords/protected.md)|Specifies the declared accessibility of types and type members.|  
|[abstract](../../../csharp/language-reference/keywords/abstract.md)|Indicates that a class is intended only to be a base class of other classes.|  
|[async](../../../csharp/language-reference/keywords/async.md)|Indicates that the modified method, lambda expression, or anonymous method is asynchronous.|  
|[const](../../../csharp/language-reference/keywords/const.md)|Specifies that the value of the field or the local variable cannot be modified.|  
|[event](../../../csharp/language-reference/keywords/event.md)|Declares an event.|  
|[extern](../../../csharp/language-reference/keywords/extern.md)|Indicates that the method is implemented externally.|  
|[new](../../../csharp/language-reference/keywords/new.md)|Explicitly hides a member inherited from a base class.|  
|[override](../../../csharp/language-reference/keywords/override.md)|Provides a new implementation of a virtual member inherited from a base class.|  
|[partial](../../../csharp/language-reference/keywords/partial-type.md)|Defines partial classes, structs and methods throughout the same assembly.|  
|[readonly](../../../csharp/language-reference/keywords/readonly.md)|Declares a field that can only be assigned values as part of the declaration or in a constructor in the same class.|  
|[sealed](../../../csharp/language-reference/keywords/sealed.md)|Specifies that a class cannot be inherited.|  
|[static](../../../csharp/language-reference/keywords/static.md)|Declares a member that belongs to the type itself instead of to a specific object.|  
|[unsafe](../../../csharp/language-reference/keywords/unsafe.md)|Declares an unsafe context.|  
|[virtual](../../../csharp/language-reference/keywords/virtual.md)|Declares a method or an accessor whose implementation can be changed by an overriding member in a derived class.|  
|[volatile](../../../csharp/language-reference/keywords/volatile.md)|Indicates that a field can be modified in the program by something such as the operating system, the hardware, or a concurrently executing thread.|  
  
## See Also  
 [C# Reference](../../../csharp/language-reference/index.md)   
 [C# Programming Guide](../../../csharp/programming-guide/index.md)   
 [C# Keywords](../../../csharp/language-reference/keywords/index.md)