---
title: "Compiler Error CS0746 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0746"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0746"
ms.assetid: 36baf7f2-b092-422c-ab53-95154bfceb0a
caps.latest.revision: 6
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0746
Invalid anonymous type member declarator. Anonymous type members must be declared with a member assignment, simple name or member access.  
  
 An anonymous type must be declared with a member assignment, simple name, or member access.  
  
## To correct this error  
  
1.  Ensure that your declaration uses only member assignment, simple names, or member access expressions.  
  
## Example  
 The following code generates CS0746 in the declaration of `incorrect_1` and `incorrect_2`. The following declarations show two of the correct ways to declare an anonymous type.  
  
```  
// cs0746.cs  
public class C  
{  
    public static int Main()  
    {  
        int i = 100;  
        string s = "Bottles of beer.";  
  
        var incorrect_1 = new { a.b = 1 }; // CS0746   
        var incorrect_2 = new {100, "Bottles of beer."}; // CS0746  
        var correct_1 = new { i, s }; //OK  
        var correct_2 = new {num = i, message = s}; // OK  
  
        return 1;  
    }  
}  
  
```  
  
## See Also  
 [Anonymous Types](../../csharp/programming-guide/classes-and-structs/anonymous-types.md)