---
title: "Compiler Error CS0763 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS0763"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0763"
ms.assetid: 940870ba-1250-4365-acaa-7f968ee96c5b
caps.latest.revision: 5
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS0763
Both partial method declarations must be static or neither may be static.  
  
 A partial method declaration cannot have one part static and the other part not static.  
  
## To correct this error  
  
1.  Make both parts either static or non-static.  
  
## Example  
 The following code generates CS0763:  
  
```  
// cs0763.cs  
using System;  
  
    public partial class C  
    {  
        static partial void Part();  
        partial void Part() // CS0763  
        {  
        }  
  
        public static int Main()  
        {  
            return 1;  
        }  
  
    }  
```  
  
## See Also  
 [Partial Classes and Methods](../../csharp/programming-guide/classes-and-structs/partial-classes-and-methods.md)   
 [static](../../csharp/language-reference/keywords/static.md)