---
title: "Queries (Visual Basic) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "queries [Visual Basic]"
  - "LINQ, queries"
ms.assetid: 8edc717c-4a24-4cbc-9c16-11f479c935db
caps.latest.revision: 11
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Queries (Visual Basic)
[!INCLUDE[vbprvb](../../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] enables you to create [!INCLUDE[vbteclinqext](../../../csharp/getting-started/includes/vbteclinqext_md.md)] expressions in your code.  
  
## In This Section  
 [Aggregate Clause](../../../visual-basic/language-reference/queries/aggregate-clause.md)  
 Describes the `Aggregate` clause, which applies one or more aggregate functions to a collection.  
  
 [Distinct Clause](../../../visual-basic/language-reference/queries/distinct-clause.md)  
 Describes the `Distinct` clause, which restricts the values of the current range variable to eliminate duplicate values in query results.  
  
 [From Clause](../../../visual-basic/language-reference/queries/from-clause.md)  
 Describes the `From` clause, which specifies a collection and a range variable for a query.  
  
 [Group By Clause](../../../visual-basic/language-reference/queries/group-by-clause.md)  
 Describes the `Group By` clause, which groups the elements of a query result and can be used to apply aggregate functions to each group.  
  
 [Group Join Clause](../../../visual-basic/language-reference/queries/group-join-clause.md)  
 Describes the `Group Join` clause, which combines two collections into a single hierarchical collection.  
  
 [Join Clause](../../../visual-basic/language-reference/queries/join-clause.md)  
 Describes the `Join` clause, which combines two collections into a single collection.  
  
 [Let Clause](../../../visual-basic/language-reference/queries/let-clause.md)  
 Describes the `Let` clause, which computes a value and assigns it to a new variable in the query.  
  
 [Order By Clause](../../../visual-basic/language-reference/queries/order-by-clause.md)  
 Describes the `Order By` clause, which specifies the sort order for columns in a query.  
  
 [Select Clause](../../../visual-basic/language-reference/queries/select-clause.md)  
 Describes the `Select` clause, which declares a set of range variables for a query.  
  
 [Skip Clause](../../../visual-basic/language-reference/queries/skip-clause.md)  
 Describes the `Skip` clause, which bypasses a specified number of elements in a collection and then returns the remaining elements.  
  
 [Skip While Clause](../../../visual-basic/language-reference/queries/skip-while-clause.md)  
 Describes the `Skip While` clause, which bypasses elements in a collection as long as a specified condition is `true` and then returns the remaining elements.  
  
 [Take Clause](../../../visual-basic/language-reference/queries/take-clause.md)  
 Describes the `Take` clause, which returns a specified number of contiguous elements from the start of a collection.  
  
 [Take While Clause](../../../visual-basic/language-reference/queries/take-while-clause.md)  
 Describes the `Take While` clause, which includes elements in a collection as long as a specified condition is `true` and bypasses the remaining elements.  
  
 [Where Clause](../../../visual-basic/language-reference/queries/where-clause.md)  
 Describes the `Where` clause, which specifies a filtering condition for a query.  
  
## See Also  
 [LINQ](../../../visual-basic/programming-guide/language-features/linq/index.md)   
 [Introduction to LINQ in Visual Basic](../../../visual-basic/programming-guide/language-features/linq/introduction-to-linq.md)