---
title: "Property Get-Let-Set are no longer supported; use the new Property declaration syntax | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc30808"
  - "bc30808"
helpviewer_keywords: 
  - "BC30808"
ms.assetid: c8a803eb-316d-4f73-b6ef-27a2914409f3
caps.latest.revision: 10
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Property Get/Let/Set are no longer supported; use the new Property declaration syntax
`Property Get/Let/Set` are no longer supported; use the new `Property` declaration syntax.  
  
 The syntax for declaring properties has changed. Properties are now defined within blocks.  
  
 **Error ID:** BC30808  
  
## To correct this error  
  
1.  Define properties in blocks of code that begin with the `Property` keyword. End properties using the `End Property` construct.  
  
2.  Define `Get` property procedures within property blocks with the `Get` keyword. End `Get` property procedures with the `End Get` construct.  
  
3.  Define property `Set` procedures within property blocks with the `Set` keyword. End `Set` property procedures with the `End Set` construct.  
  
4.  Use `Set` property procedures for all property assignments. `Let` property procedures are no longer necessary, or supported.  
  
## See Also  
 [Property Statement](../../visual-basic/language-reference/statements/property-statement.md)   
 [Language Changes for Visual Basic 6.0 Users](https://msdn.microsoft.com/library/skw8dhdd(v=vs.90).aspx)