---
title: "Parameter name &#39;&lt;parametername1&gt;&#39; does not match the name of the corresponding parameter, &#39;&lt;parametername2&gt;&#39;, defined on the partial method declaration &#39;&lt;methodname&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31442"
  - "bc31442"
helpviewer_keywords: 
  - "BC31442"
ms.assetid: 7f097bb2-071a-42ec-b7af-40da04f602f2
caps.latest.revision: 5
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Parameter name &#39;&lt;parametername1&gt;&#39; does not match the name of the corresponding parameter, &#39;&lt;parametername2&gt;&#39;, defined on the partial method declaration &#39;&lt;methodname&gt;&#39;
When parameters are supplied for the declaration and implementation of a partial method, the names of the corresponding parameters must be the same. For example, the following code causes this error.  
  
```vb  
Partial Class Product  
  
    ' Declaration of the partial method.  
    Partial Private Sub valueChanged(ByVal newVal As Integer)  
    End Sub  
End Class  
```  
  
```vb  
Partial Class Product  
  
    ' Implementation of the partial method. This error is  
    ' reported for parameter val.  
    ' Private Sub valueChanged(ByVal val As Integer)  
    '     MsgBox(Value was changed to " & Me.Quantity)  
    ' End Sub  
  
End Class  
```  
  
 **Error ID:** BC31442  
  
## To correct this error  
  
1.  Change the parameter name or names in the declaration or in the implementation so that corresponding parameters have the same name.  
  
## See Also  
 [Partial Methods](../../visual-basic/programming-guide/language-features/procedures/partial-methods.md)