---
title: "&#39;System.Runtime.InteropServices.DllImportAttribute&#39; cannot be applied to a method that is generic or nested in a generic type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc31526"
  - "bc31526"
helpviewer_keywords: 
  - "BC31526"
ms.assetid: 6f153808-1945-4c99-85ae-8bd3b35ee5a2
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;System.Runtime.InteropServices.DllImportAttribute&#39; cannot be applied to a method that is generic or nested in a generic type
A procedure is declared with the <xref:System.Runtime.InteropServices.DllImportAttribute>, but either the procedure is generic or it is contained in a generic class or structure.  
  
 The common language runtime (CLR) recognizes this attribute and its <xref:System.Runtime.InteropServices._Assembly.EntryPoint%2A> property as designating a replacement procedure defined in an unmanaged dynamic-link library (DLL) outside the .NET Framework. When code calls the procedure to which the <xref:System.Runtime.InteropServices.DllImportAttribute> is applied, the common language runtime calls the designated unmanaged procedure instead.  
  
 Because unmanaged platforms outside the .NET Framework do not recognize generic types, you cannot interoperate with them using generic types.  
  
 **Error ID:** BC31526  
  
## To correct this error  
  
-   If neither the procedure nor its container needs to be generic, then remove the `Of` clauses so that they are not generic.  
  
-   If the procedure or its container needs to be generic, then remove the <xref:System.Runtime.InteropServices.DllImportAttribute> from the declaration of this procedure.  
  
## See Also  
 <xref:System.Runtime.InteropServices.DllImportAttribute>   
 [Generic Types in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/generic-types.md)