Contributing to ShareLaTeX
==========================

Thank you for reading this! If you'd like to report a bug or join in the development
of ShareLaTeX, then here are some notes on how to do that.

*Note that ShareLaTeX is actually made up of many seperate repositories (a list is available
[here](https://github.com/sharelatex/sharelatex/blob/master/README.md#other-repositories)).* 

Reporting bugs and opening issues
---------------------------------

If you'd like a report a bug or open an issue then please:

1. **Find the correct repository.** ShareLaTeX is split across multiple different repositories, each containing a different service (you can find a list of [all repositories here](https://github.com/sharelatex/sharelatex/blob/master/README.md#other-repositories)). If you know the bug only applies to one service, then please open an issue in that repository. For general bugs and issues that span more than one service, please open an issue in the [sharelatex/sharelatex](https://github.com/sharelatex/sharelatex) repository.
2. **Check if there is an existing issue.** If there is then please add
   any more information that you have, or give it a "+1" in the comments.

When submitting an issue please describe the issue as clearly as possible, including how to
reproduce the bug, which situations it appears in, what you expected to happen, and what actually happens.
If you can include a screenshot for front end issues that is very helpful.

Pull Requests
-------------

See [our wiki](https://github.com/sharelatex/sharelatex/wiki/Developer-Guidelines)
for how to manage the ShareLaTeX development environment and for our developer guidelines.

We love pull requests, so be bold with them! Don't be afraid of going ahead
and changing something, or adding a new feature. We're very happy to work with you
to get your changes merged into ShareLaTeX.

If you've got an idea for a change then please discuss it in the open first, 
either by opening an issue, or by joining us in our
[development chat room](http://www.hipchat.com/g1nJMcj7b).

If you're looking for something to work on, then take a look at our [development roadmap](https://github.com/sharelatex/sharelatex/wiki/Development-Roadmap), or have a look at the open issues in any of the repositories listed [here](https://github.com/sharelatex/sharelatex/blob/master/README.md#other-repositories).

Developer Chat Room
-------------------

If you want to ask any questions in real-time, or get a feel for what's going on
then please drop into our [development chat room](http://www.hipchat.com/g1nJMcj7b).
If no one is online then you can still leave a message that will hopefully get a reply
when we return.

Security
--------

Please do not publish security vulnerabilities publicly until we've had a chance
to address them. All security related issues/patches should be sent directly to
team@sharelatex.com where we will attempt to address them quickly. If you're
unsure whether something is a security issue or not, then please be cautious and
contact us at team@sharelatex.com first.

Contributor License Agreement
-----------------------------

Before we can accept and contributions of code, we need you to agree to our 
[Contributor License Agreement](https://sharelatex.wufoo.com/forms/sharelatex-contributor-license-agreement/).
This is to ensure that you own the copyright of your contribution, and that you
agree to give us a license to use it in both the open source version, and the version
of ShareLaTeX running at www.sharelatex.com, which may have additional changes.
